/*
 * Decompiled with CFR 0.152.
 */
package com.jme.animation;

import com.jme.math.Quaternion;
import com.jme.math.TransformQuaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.logging.Logger;

public class SpatialTransformer
extends Controller {
    private static final Logger logger = Logger.getLogger(SpatialTransformer.class.getName());
    private static final long serialVersionUID = 1L;
    private int numObjects;
    public Spatial[] toChange;
    private TransformQuaternion[] pivots;
    public int[] parentIndexes;
    public ArrayList<PointInTime> keyframes;
    private float curTime;
    private transient PointInTime beginPointTime;
    private transient PointInTime endPointTime;
    private boolean[] haveChanged;
    private float delta;
    private static final Vector3f unSyncbeginPos = new Vector3f();
    private static final Vector3f unSyncendPos = new Vector3f();
    private static final Quaternion unSyncbeginRot = new Quaternion();
    private static final Quaternion unSyncendRot = new Quaternion();

    public SpatialTransformer() {
    }

    public SpatialTransformer(int n) {
        this.numObjects = n;
        this.toChange = new Spatial[n];
        this.pivots = new TransformQuaternion[n];
        this.parentIndexes = new int[n];
        this.haveChanged = new boolean[n];
        Arrays.fill(this.parentIndexes, -1);
        for (int i = 0; i < n; ++i) {
            this.pivots[i] = new TransformQuaternion();
        }
        this.keyframes = new ArrayList();
    }

    public void update(float f) {
        this.curTime += f * this.getSpeed();
        this.setBeginAndEnd();
        Arrays.fill(this.haveChanged, false);
        this.delta = this.endPointTime.time - this.beginPointTime.time;
        if (this.delta != 0.0f) {
            this.delta = (this.curTime - this.beginPointTime.time) / this.delta;
        }
        for (int i = 0; i < this.numObjects; ++i) {
            this.updatePivot(i);
            this.pivots[i].applyToSpatial(this.toChange[i]);
        }
    }

    private void updatePivot(int n) {
        if (this.haveChanged[n]) {
            return;
        }
        this.haveChanged[n] = true;
        int n2 = this.parentIndexes[n];
        if (n2 != -1) {
            this.updatePivot(n2);
        }
        this.pivots[n].interpolateTransforms(this.beginPointTime.look[n], this.endPointTime.look[n], this.delta);
        if (n2 != -1) {
            this.pivots[n].combineWithParent(this.pivots[n2]);
        }
    }

    public void setMinTime(float f) {
        if (this.keyframes != null && this.keyframes.size() > 0) {
            float f2 = this.keyframes.get((int)0).time;
            float f3 = this.keyframes.get((int)(this.keyframes.size() - 1)).time;
            if (f < f2) {
                f = f2;
            }
            if (f > f3) {
                f = f3;
            }
        }
        this.curTime = f;
        super.setMinTime(f);
    }

    public void setMaxTime(float f) {
        if (this.keyframes != null && this.keyframes.size() > 0) {
            float f2 = this.keyframes.get((int)0).time;
            float f3 = this.keyframes.get((int)(this.keyframes.size() - 1)).time;
            if (f < f2) {
                f = f2;
            }
            if (f > f3) {
                f = f3;
            }
        }
        super.setMaxTime(f);
    }

    public void setNewAnimationTimes(float f, float f2) {
        if (f < 0.0f || f > this.keyframes.get((int)(this.keyframes.size() - 1)).time) {
            logger.warning("Attempt to set invalid begintime:" + f);
            return;
        }
        if (f2 < 0.0f || f2 > this.keyframes.get((int)(this.keyframes.size() - 1)).time) {
            logger.warning("Attempt to set invalid endtime:" + f2);
            return;
        }
        this.setMinTime(f);
        this.setMaxTime(f2);
        this.setActive(true);
        if (f <= f2) {
            this.curTime = f;
            if (f == f2) {
                this.update(0.0f);
                this.setActive(false);
            }
        } else {
            this.curTime = f2;
        }
    }

    public float getCurTime() {
        return this.curTime;
    }

    public void setCurTime(float f) {
        this.curTime = f;
    }

    private void setBeginAndEnd() {
        float f = this.getMinTime();
        float f2 = this.getMaxTime();
        if (this.getSpeed() > 0.0f) {
            if (this.curTime >= f2) {
                if (this.getRepeatType() == 1) {
                    int[] nArray = this.findIndicesBeforeAfter(f);
                    int n = nArray[0];
                    int n2 = nArray[1];
                    this.beginPointTime = this.keyframes.get(n);
                    this.endPointTime = this.keyframes.get(n2);
                    float f3 = this.curTime - f2;
                    this.curTime = f + f3;
                } else if (this.getRepeatType() == 0) {
                    int[] nArray = this.findIndicesBeforeAfter(f2);
                    int n = nArray[1];
                    this.endPointTime = this.beginPointTime = this.keyframes.get(n);
                    this.curTime = f2;
                } else if (this.getRepeatType() == 2) {
                    int[] nArray = this.findIndicesBeforeAfter(f2);
                    int n = nArray[0];
                    int n3 = nArray[1];
                    this.beginPointTime = this.keyframes.get(n);
                    this.endPointTime = this.keyframes.get(n3);
                    float f4 = this.curTime - f2;
                    this.curTime = f2 - f4;
                    this.setSpeed(-this.getSpeed());
                }
            } else if (this.curTime <= f) {
                int[] nArray = this.findIndicesBeforeAfter(f);
                int n = nArray[0];
                int n4 = nArray[1];
                this.beginPointTime = this.keyframes.get(n);
                this.endPointTime = this.keyframes.get(n4);
                this.curTime = f;
            } else {
                int[] nArray = this.findIndicesBeforeAfter(this.curTime);
                int n = nArray[0];
                int n5 = nArray[1];
                this.beginPointTime = this.keyframes.get(n);
                this.endPointTime = this.keyframes.get(n5);
            }
        } else if (this.getSpeed() < 0.0f) {
            if (this.curTime <= f) {
                if (this.getRepeatType() == 1) {
                    int[] nArray = this.findIndicesBeforeAfter(f2);
                    int n = nArray[1];
                    int n6 = nArray[0];
                    this.beginPointTime = this.keyframes.get(n);
                    this.endPointTime = this.keyframes.get(n6);
                    float f5 = f - this.curTime;
                    this.curTime = f2 - f5;
                } else if (this.getRepeatType() == 0) {
                    int[] nArray = this.findIndicesBeforeAfter(f);
                    int n = nArray[1];
                    this.endPointTime = this.beginPointTime = this.keyframes.get(n);
                    this.curTime = f;
                } else if (this.getRepeatType() == 2) {
                    int[] nArray = this.findIndicesBeforeAfter(f);
                    int n = nArray[1];
                    int n7 = nArray[0];
                    this.beginPointTime = this.keyframes.get(n);
                    this.endPointTime = this.keyframes.get(n7);
                    float f6 = f - this.curTime;
                    this.curTime = f + f6;
                    this.setSpeed(-this.getSpeed());
                }
            } else if (this.curTime >= f2) {
                int[] nArray = this.findIndicesBeforeAfter(f2);
                int n = nArray[1];
                int n8 = nArray[0];
                this.beginPointTime = this.keyframes.get(n);
                this.endPointTime = this.keyframes.get(n8);
                this.curTime = f2;
            } else {
                int[] nArray = this.findIndicesBeforeAfter(this.curTime);
                int n = nArray[1];
                int n9 = nArray[0];
                this.beginPointTime = this.keyframes.get(n);
                this.endPointTime = this.keyframes.get(n9);
            }
        } else {
            this.beginPointTime = this.keyframes.get(0);
            this.endPointTime = this.keyframes.get(0);
        }
    }

    int[] findIndicesBeforeAfter(float f) {
        int[] nArray = new int[]{0, this.keyframes.size() - 1};
        int n = 0;
        while (n < this.keyframes.size()) {
            float f2 = this.keyframes.get((int)n).time;
            if (f2 >= f) {
                nArray[1] = n;
                return nArray;
            }
            nArray[0] = n++;
        }
        return nArray;
    }

    public void setObject(Spatial spatial, int n, int n2) {
        this.toChange[n] = spatial;
        this.pivots[n].setTranslation(spatial.getLocalTranslation());
        this.pivots[n].setScale(spatial.getLocalScale());
        this.pivots[n].setRotationQuaternion(spatial.getLocalRotation());
        this.parentIndexes[n] = n2;
    }

    private PointInTime findTime(float f) {
        for (int i = 0; i < this.keyframes.size(); ++i) {
            if (this.keyframes.get((int)i).time == f) {
                this.setMinTime(Math.min(f, this.getMinTime()));
                this.setMaxTime(Math.max(f, this.getMaxTime()));
                return this.keyframes.get(i);
            }
            if (!(this.keyframes.get((int)i).time > f)) continue;
            PointInTime pointInTime = new PointInTime(f, this.numObjects);
            this.keyframes.add(i, pointInTime);
            this.setMinTime(Math.min(f, this.getMinTime()));
            this.setMaxTime(Math.max(f, this.getMaxTime()));
            return pointInTime;
        }
        PointInTime pointInTime = new PointInTime(f, this.numObjects);
        this.keyframes.add(pointInTime);
        this.setMinTime(Math.min(f, this.getMinTime()));
        this.setMaxTime(Math.max(f, this.getMaxTime()));
        return pointInTime;
    }

    public void setRotation(int n, float f, Quaternion quaternion) {
        PointInTime pointInTime = this.findTime(f);
        pointInTime.setRotation(n, quaternion);
    }

    public void setPosition(int n, float f, Vector3f vector3f) {
        PointInTime pointInTime = this.findTime(f);
        pointInTime.setTranslation(n, vector3f);
    }

    public void setScale(int n, float f, Vector3f vector3f) {
        PointInTime pointInTime = this.findTime(f);
        pointInTime.setScale(n, vector3f);
    }

    public void interpolateMissing() {
        if (this.keyframes.size() != 1) {
            this.fillTrans();
            this.fillRots();
            this.fillScales();
        }
        for (int i = 0; i < this.numObjects; ++i) {
            this.pivots[i].applyToSpatial(this.toChange[i]);
        }
    }

    private void fillScales() {
        for (int i = 0; i < this.numObjects; ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.keyframes.size() && !this.keyframes.get((int)n2).usedScale.get(i); ++n2) {
            }
            if (n2 == this.keyframes.size()) {
                for (PointInTime pointInTime : this.keyframes) {
                    this.pivots[i].getScale(pointInTime.look[i].getScale());
                }
                continue;
            }
            if (n2 != 0) {
                this.keyframes.get((int)n2).look[i].getScale(unSyncbeginPos);
                for (int j = 0; j < n2; ++j) {
                    this.keyframes.get((int)j).look[i].setScale(unSyncbeginPos);
                }
            }
            int n3 = n2;
            for (n = n2 + 1; n < this.keyframes.size(); ++n) {
                if (!this.keyframes.get((int)n).usedScale.get(i)) continue;
                this.fillScale(i, n3, n);
                n3 = n;
            }
            if (n3 != this.keyframes.size() - 1) {
                this.keyframes.get((int)(this.keyframes.size() - 1)).look[i].setScale(this.keyframes.get((int)n3).look[i].getScale(null));
            }
            this.keyframes.get((int)n3).look[i].getScale(unSyncbeginPos);
            for (n = n3 + 1; n < this.keyframes.size(); ++n) {
                this.keyframes.get((int)n).look[i].setScale(unSyncbeginPos);
            }
        }
    }

    private void fillScale(int n, int n2, int n3) {
        this.keyframes.get((int)n2).look[n].getScale(unSyncbeginPos);
        this.keyframes.get((int)n3).look[n].getScale(unSyncendPos);
        float f = this.keyframes.get((int)n2).time;
        float f2 = this.keyframes.get((int)n3).time;
        float f3 = f2 - f;
        Vector3f vector3f = new Vector3f();
        for (int i = n2 + 1; i < n3; ++i) {
            float f4 = this.keyframes.get((int)i).time;
            vector3f.interpolate(unSyncbeginPos, unSyncendPos, (f4 - f) / f3);
            this.keyframes.get((int)i).look[n].setScale(vector3f);
        }
    }

    private void fillRots() {
        for (int i = 0; i < this.numObjects; ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.keyframes.size() && !this.keyframes.get((int)n2).usedRot.get(i); ++n2) {
            }
            if (n2 == this.keyframes.size()) {
                for (PointInTime pointInTime : this.keyframes) {
                    this.pivots[i].getRotation(pointInTime.look[i].getRotation());
                }
                continue;
            }
            if (n2 != 0) {
                this.keyframes.get((int)n2).look[i].getRotation(unSyncbeginRot);
                for (int j = 0; j < n2; ++j) {
                    this.keyframes.get((int)j).look[i].setRotationQuaternion(unSyncbeginRot);
                }
            }
            int n3 = n2;
            for (n = n2 + 1; n < this.keyframes.size(); ++n) {
                if (!this.keyframes.get((int)n).usedRot.get(i)) continue;
                this.fillQuats(i, n3, n);
                n3 = n;
            }
            this.keyframes.get((int)n3).look[i].getRotation(unSyncbeginRot);
            for (n = n3 + 1; n < this.keyframes.size(); ++n) {
                this.keyframes.get((int)n).look[i].setRotationQuaternion(unSyncbeginRot);
            }
        }
    }

    private void fillQuats(int n, int n2, int n3) {
        this.keyframes.get((int)n2).look[n].getRotation(unSyncbeginRot);
        this.keyframes.get((int)n3).look[n].getRotation(unSyncendRot);
        float f = this.keyframes.get((int)n2).time;
        float f2 = this.keyframes.get((int)n3).time;
        float f3 = f2 - f;
        Quaternion quaternion = new Quaternion();
        for (int i = n2 + 1; i < n3; ++i) {
            float f4 = this.keyframes.get((int)i).time;
            quaternion.slerp(unSyncbeginRot, unSyncendRot, (f4 - f) / f3);
            this.keyframes.get((int)i).look[n].setRotationQuaternion(quaternion);
        }
    }

    private void fillTrans() {
        for (int i = 0; i < this.numObjects; ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.keyframes.size() && !this.keyframes.get((int)n2).usedTrans.get(i); ++n2) {
            }
            if (n2 == this.keyframes.size()) {
                for (PointInTime pointInTime : this.keyframes) {
                    this.pivots[i].getTranslation(pointInTime.look[i].getTranslation());
                }
                continue;
            }
            if (n2 != 0) {
                this.keyframes.get((int)n2).look[i].getTranslation(unSyncbeginPos);
                for (int j = 0; j < n2; ++j) {
                    this.keyframes.get((int)j).look[i].setTranslation(unSyncbeginPos);
                }
            }
            int n3 = n2;
            for (n = n2 + 1; n < this.keyframes.size(); ++n) {
                if (!this.keyframes.get((int)n).usedTrans.get(i)) continue;
                this.fillVecs(i, n3, n);
                n3 = n;
            }
            if (n3 != this.keyframes.size() - 1) {
                this.keyframes.get((int)(this.keyframes.size() - 1)).look[i].setTranslation(this.keyframes.get((int)n3).look[i].getTranslation(null));
            }
            this.keyframes.get((int)n3).look[i].getTranslation(unSyncbeginPos);
            for (n = n3 + 1; n < this.keyframes.size(); ++n) {
                this.keyframes.get((int)n).look[i].setTranslation(unSyncbeginPos);
            }
        }
    }

    private void fillVecs(int n, int n2, int n3) {
        this.keyframes.get((int)n2).look[n].getTranslation(unSyncbeginPos);
        this.keyframes.get((int)n3).look[n].getTranslation(unSyncendPos);
        float f = this.keyframes.get((int)n2).time;
        float f2 = this.keyframes.get((int)n3).time;
        float f3 = f2 - f;
        Vector3f vector3f = new Vector3f();
        for (int i = n2 + 1; i < n3; ++i) {
            float f4 = this.keyframes.get((int)i).time;
            vector3f.interpolate(unSyncbeginPos, unSyncendPos, (f4 - f) / f3);
            this.keyframes.get((int)i).look[n].setTranslation(vector3f);
        }
    }

    public int getNumObjects() {
        return this.numObjects;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.numObjects, "numObjects", 0);
        outputCapsule.write(this.toChange, "toChange", new Spatial[0]);
        outputCapsule.write(this.pivots, "pivots", new TransformQuaternion[0]);
        outputCapsule.write(this.parentIndexes, "parentIndexes", new int[0]);
        outputCapsule.writeSavableArrayList(this.keyframes, "keyframes", new ArrayList());
        outputCapsule.write(this.haveChanged, "haveChanged", new boolean[0]);
        outputCapsule.write(this.beginPointTime, "beginPointTime", null);
        outputCapsule.write(this.endPointTime, "endPointTime", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        int n;
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.numObjects = inputCapsule.readInt("numObjects", 0);
        Savable[] savableArray = inputCapsule.readSavableArray("toChange", new Spatial[0]);
        if (savableArray == null) {
            this.toChange = null;
        } else {
            this.toChange = new Spatial[savableArray.length];
            for (n = 0; n < savableArray.length; ++n) {
                this.toChange[n] = (Spatial)savableArray[n];
            }
        }
        savableArray = inputCapsule.readSavableArray("pivots", new TransformQuaternion[0]);
        if (savableArray == null) {
            this.pivots = null;
        } else {
            this.pivots = new TransformQuaternion[savableArray.length];
            for (n = 0; n < savableArray.length; ++n) {
                this.pivots[n] = (TransformQuaternion)savableArray[n];
            }
        }
        this.parentIndexes = inputCapsule.readIntArray("parentIndexes", new int[0]);
        this.keyframes = inputCapsule.readSavableArrayList("keyframes", new ArrayList());
        this.haveChanged = inputCapsule.readBooleanArray("haveChanged", new boolean[0]);
        this.beginPointTime = (PointInTime)inputCapsule.readSavable("beginPointTime", null);
        this.endPointTime = (PointInTime)inputCapsule.readSavable("endPointTime", null);
    }

    public static class PointInTime
    implements Savable {
        public BitSet usedRot;
        public BitSet usedTrans;
        public BitSet usedScale;
        public float time;
        public TransformQuaternion[] look;

        public PointInTime() {
        }

        public PointInTime(float f, int n) {
            this.look = new TransformQuaternion[n];
            this.usedRot = new BitSet(n);
            this.usedTrans = new BitSet(n);
            this.usedScale = new BitSet(n);
            for (int i = 0; i < this.look.length; ++i) {
                this.look[i] = new TransformQuaternion();
            }
            this.time = f;
        }

        void setRotation(int n, Quaternion quaternion) {
            this.look[n].setRotationQuaternion(quaternion);
            this.usedRot.set(n);
        }

        void setTranslation(int n, Vector3f vector3f) {
            this.look[n].setTranslation(vector3f);
            this.usedTrans.set(n);
        }

        void setScale(int n, Vector3f vector3f) {
            this.look[n].setScale(vector3f);
            this.usedScale.set(n);
        }

        public void write(JMEExporter jMEExporter) throws IOException {
            OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
            outputCapsule.write(this.usedRot, "usedRot", null);
            outputCapsule.write(this.usedTrans, "usedTrans", null);
            outputCapsule.write(this.usedScale, "usedScale", null);
            outputCapsule.write(this.time, "time", 0.0f);
            outputCapsule.write(this.look, "look", null);
        }

        public void read(JMEImporter jMEImporter) throws IOException {
            InputCapsule inputCapsule = jMEImporter.getCapsule(this);
            this.usedRot = inputCapsule.readBitSet("usedRot", null);
            this.usedTrans = inputCapsule.readBitSet("usedTrans", null);
            this.usedScale = inputCapsule.readBitSet("usedScale", null);
            this.time = inputCapsule.readFloat("time", 0.0f);
            Savable[] savableArray = inputCapsule.readSavableArray("look", null);
            if (savableArray == null) {
                this.look = null;
            } else {
                this.look = new TransformQuaternion[savableArray.length];
                for (int i = 0; i < savableArray.length; ++i) {
                    this.look[i] = (TransformQuaternion)savableArray[i];
                }
            }
        }

        public Class getClassTag() {
            return this.getClass();
        }
    }
}

