/*
 * Decompiled with CFR 0.152.
 */
package de.vxart.wurm;

import de.vxart.zipupdate.UpdateEngine;
import de.vxart.zipupdate.UpdateLocation;
import de.vxart.zipupdate.ui.MultiProgressDialog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class PackUpdateEngine {
    private static Logger logger = Logger.getLogger(PackUpdateEngine.class.getName());
    public static final String PACK_DESCRIPTOR = "pack.txt";

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: java de.vxart.wurm.PackUpdateEngine <pack file | directory>");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        File[] fileArray = null;
        if (file.isFile()) {
            logger.log(Level.INFO, "Generating index for " + file);
            fileArray = new File[]{file};
        } else if (file.isDirectory()) {
            fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
            });
        } else {
            logger.log(Level.WARNING, "Neither directory nor ZIP/JAR file: " + file);
            System.exit(2);
        }
        try {
            PackUpdateEngine.update(fileArray);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Failed to update packs", exception);
        }
    }

    public static void update(File[] fileArray) throws IOException, IllegalArgumentException {
        ZipFile[] zipFileArray = new ZipFile[fileArray.length];
        UpdateLocation[] updateLocationArray = new UpdateLocation[fileArray.length];
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            zipFileArray[i] = new ZipFile(fileArray[i]);
            Properties properties = PackUpdateEngine.getPackDescriptor(zipFileArray[i]);
            String string = properties.getProperty("url").replaceAll("www.wurmonline.com", "wurm.vxart.de");
            updateLocationArray[i] = new UpdateLocation(new URL(string));
            stringArray[i] = properties.getProperty("description");
        }
        UpdateEngine updateEngine = new UpdateEngine();
        updateEngine.addProgressListener(new MultiProgressDialog());
        updateEngine.update(zipFileArray, updateLocationArray, stringArray);
    }

    private static Properties getPackDescriptor(ZipFile zipFile) throws IOException {
        InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(PACK_DESCRIPTOR));
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }
}

