/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.launcher;

import com.turborilla.msm.launcher.AuthenticationDialog;
import com.turborilla.msm.launcher.ChangeLogDialog;
import com.turborilla.msm.launcher.DynamicUpdater;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Launcher {
    private static Logger logger = Logger.getLogger(Launcher.class.getCanonicalName());
    private static AuthenticationDialog dialog;
    private String[] executable;
    private static final boolean skipUpdate = true;
    private static Preferences settings;

    public Launcher(String[] stringArray) {
        this.executable = stringArray != null ? stringArray : null;
        settings = Preferences.userRoot().node("Turborilla Updater");
    }

    public void launch() {
        if (this.executable == null) {
            return;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(this.executable);
        Process process = null;
        try {
            process = processBuilder.start();
        }
        catch (Exception exception) {
            logger.severe("Launch failed due to " + exception);
            Launcher.showDialog("Mad Skills Motocross Updater", "There was an error, try starting \"game\" in the directory \"data\". \nError: " + exception.getMessage() + "\nWorking directory: " + System.getProperty("user.dir"));
            System.exit(-1);
        }
    }

    private static String getUpdateInfoQuery(String string, String string2) {
        String string3 = "msmfullupdateinfo.php?TURBO_ACTION=login&TURBO_EMAIL=" + string + "&TURBO_PASSWORD=" + string2;
        return string3;
    }

    private static DynamicUpdater initUpdater() {
        DynamicUpdater dynamicUpdater = new DynamicUpdater("turborilla.com", "msmgetbuildnr.php");
        return dynamicUpdater;
    }

    public static void main(String[] stringArray) {
        Launcher.initLogging();
        DynamicUpdater dynamicUpdater = null;
        String string = System.getProperty("os.name").toLowerCase();
        boolean bl = string.startsWith("mac os x");
        if (bl) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Mad Skills Motocross");
        }
        Launcher launcher = new Launcher((String[])(stringArray.length > 0 ? stringArray : null));
        boolean bl2 = false;
        if (bl2 && dynamicUpdater != null) {
            Launcher.showChangeLog(dynamicUpdater);
        }
        launcher.launch();
        System.exit(0);
    }

    private static void setupAuthenticationDialog(String string, String string2, final Launcher launcher) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        JFrame jFrame = new JFrame();
        dialog = new AuthenticationDialog(jFrame, "Mad Skills Motocross Auto-Updater", true, string, string2);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().getOwner().dispose();
                System.exit(0);
            }
        });
        Launcher.center(dialog);
        dialog.getProgressPanel().getCancelButton().setEnabled(false);
        dialog.getProgressPanel().setFinishedListener(new Runnable(){

            public void run() {
                dialog.setVisible(false);
            }
        });
        dialog.getOkButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = dialog.getEmailTextfield().getText();
                String string2 = new String(dialog.getPasswordTextfield().getPassword());
                try {
                    string2 = Launcher.SHA1(string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                String string3 = string2;
                final DynamicUpdater dynamicUpdater = Launcher.initUpdater();
                try {
                    final Properties properties = dynamicUpdater.getUpdateInfo(Launcher.getUpdateInfoQuery(string, string2));
                    settings.put("user", string);
                    settings.put("pass", string3);
                    if (dynamicUpdater.isNewBuildNumber(string)) {
                        dialog.showUpdatingPanel();
                        Runnable runnable = new Runnable(){

                            public void run() {
                                try {
                                    dynamicUpdater.update(properties, dialog.getMultiProgressListener());
                                }
                                catch (Exception exception) {
                                    logger.severe("Update failed due to " + exception);
                                    dialog.setVisible(false);
                                    Launcher.showDialog("Mad Skills Motocross", "Update failed, please download and install a newer copy of the game.");
                                    return;
                                }
                            }
                        };
                        new Thread(runnable).start();
                    } else {
                        dialog.setVisible(false);
                    }
                }
                catch (Exception exception) {
                    if (exception.getMessage() != null && exception.getMessage().indexOf("403") >= 0) {
                        dialog.setLoginLabelText("<html><color=#FF0000>Wrong email or password entered, please try again.</color></html>");
                        dialog.getEmailTextfield().setText(string);
                        dialog.showLoginPanel();
                        return;
                    }
                    logger.severe("Update failed due to " + exception);
                    dialog.setVisible(false);
                    Launcher.showDialog("Mad Skills Motocross", "Update failed, please download and install a newer copy of the game.");
                    return;
                }
            }
        });
        dialog.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent windowEvent) {
            }

            public void windowClosed(WindowEvent windowEvent) {
                if (dialog != null && dialog.getOwner() != null) {
                    dialog.dispose();
                    dialog.getOwner().dispose();
                }
                launcher.launch();
                System.exit(0);
            }

            public void windowClosing(WindowEvent windowEvent) {
            }

            public void windowDeactivated(WindowEvent windowEvent) {
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }
        });
    }

    private static void initLogging() {
        try {
            Handler handler2;
            for (Handler handler2 : Logger.getLogger("").getHandlers()) {
                Logger.getLogger("").removeHandler(handler2);
            }
            File file = File.createTempFile("updaterlog", "txt");
            FileHandler fileHandler = new FileHandler(file.getAbsolutePath());
            Logger.getLogger("").addHandler(fileHandler);
            Logger.getLogger("de.vxart.zipupdate").addHandler(fileHandler);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            Logger.getLogger("com.jme").addHandler(consoleHandler);
            Logger.getLogger("com.jmex").addHandler(consoleHandler);
            handler2 = new ConsoleHandler();
            Logger.getLogger("com.turborilla").addHandler(fileHandler);
            ConsoleHandler consoleHandler2 = new ConsoleHandler();
            Logger.getLogger("com.turborilla.statemachine").addHandler(consoleHandler2);
            Logger.getLogger("com.turborilla.xbike.statemachine").addHandler(consoleHandler2);
            fileHandler.setLevel(Level.FINEST);
            consoleHandler.setLevel(Level.SEVERE);
            handler2.setLevel(Level.SEVERE);
            consoleHandler2.setLevel(Level.INFO);
            String string = System.getProperty("java.io.tmpdir");
            if (!string.endsWith("/") && !string.endsWith("\\")) {
                string = string + System.getProperty("file.separator");
            }
            try {
                PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(string + "msm_updater_outerr.txt")));
                System.setOut(printStream);
                System.setErr(printStream);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showDialog(String string, String string2) {
        JFrame jFrame = new JFrame(){

            public Dimension getPreferredSize() {
                return new Dimension(200, 100);
            }
        };
        jFrame.setTitle(string);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setAlwaysOnTop(true);
        jFrame.setVisible(false);
        JOptionPane.showMessageDialog(jFrame, string2);
    }

    public static void center(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        component.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private static String convertToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] >>> 4 & 0xF;
            int n2 = 0;
            do {
                if (0 <= n && n <= 9) {
                    stringBuffer.append((char)(48 + n));
                } else {
                    stringBuffer.append((char)(97 + (n - 10)));
                }
                n = byArray[i] & 0xF;
            } while (n2++ < 1);
        }
        return stringBuffer.toString();
    }

    public static String SHA1(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] byArray = new byte[40];
        messageDigest.update(string.getBytes("iso-8859-1"), 0, string.length());
        byArray = messageDigest.digest();
        return Launcher.convertToHex(byArray);
    }

    private static void showChangeLog(final DynamicUpdater dynamicUpdater) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    String string = "";
                    try {
                        string = dynamicUpdater.getChangeLog("msmgetchangelog.php");
                    }
                    catch (IOException iOException) {
                        logger.severe("Could not download changelog due to " + iOException);
                    }
                    if (string == null || string.length() <= 0) {
                        return;
                    }
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    ChangeLogDialog changeLogDialog = new ChangeLogDialog("Mad Skills Motocross", string);
                    Launcher.center(changeLogDialog);
                    changeLogDialog.setVisible(true);
                    changeLogDialog.dispose();
                }
            });
        }
        catch (Exception exception) {
            logger.severe("Could not show change dialog due to " + exception);
        }
    }
}

