/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.launcher;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class Download
implements Runnable {
    public static final int IDLE = 0;
    public static final int DOWNLOADING = 1;
    public static final int SUCCESS = 2;
    public static final int CANCELED = 3;
    public static final int ERROR = 4;
    private static final int BUFFER_SIZE = 1024;
    private static final int MAX_UNSUCCESSFUL_ATTEMPTS = 10;
    private static final int TIME_BETWEEN_ATTEMPTS = 3000;
    private final Object lock = new Object();
    private int state;
    private long startTime;
    private int unsuccessfulAttempts;
    private boolean resetUnsuccessfulAttempts;
    private URL url;
    private int size;
    private int startPosition;
    private int currentPosition;
    private int restartPosition;
    private Throwable lastException;
    private byte[] data;
    private String authorizationString;

    public static Download startDownload(URL uRL, String string) {
        return Download.startDownload(uRL, string, null);
    }

    public static Download startDownload(URL uRL, String string, String string2) {
        URL uRL2;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        Download download = new Download(uRL2, string2);
        download.start();
        return download;
    }

    public Download(URL uRL, String string) {
        this.authorizationString = string;
        this.url = uRL;
        this.state = 0;
        this.size = -1;
        this.startTime = -1L;
        this.unsuccessfulAttempts = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException();
            }
            this.setState(1);
            Thread thread = new Thread((Runnable)this, "PulpCore-Download");
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 1) {
                this.setState(3);
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getBytesRead() {
        return this.currentPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPercentDownloaded() {
        Object object = this.lock;
        synchronized (object) {
            if (this.size <= 0) {
                return -1.0;
            }
            return (double)this.currentPosition / (double)this.size;
        }
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getState() {
        return this.state;
    }

    private final void setState(int n) {
        this.state = n;
        if (n == 4) {
            this.data = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEstimatedTimeRemaining() {
        Object object = this.lock;
        synchronized (object) {
            if (this.size <= 0 || this.startTime == -1L) {
                return -1L;
            }
            float f = (float)(this.currentPosition - this.startPosition) / (float)(this.size - this.startPosition);
            if (f == 0.0f) {
                return -1L;
            }
            long l = System.currentTimeMillis() - this.startTime;
            return Math.round((1.0f - f) * (float)l / f);
        }
    }

    public void run() {
        while (true) {
            try {
                this.attemptDownload();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.lastException = fileNotFoundException;
                this.setState(4);
                return;
            }
            catch (IOException iOException) {
                this.lastException = iOException;
                ++this.unsuccessfulAttempts;
            }
            catch (Throwable throwable) {
                this.lastException = throwable;
                this.setState(4);
                return;
            }
            if (this.unsuccessfulAttempts >= 10) {
                this.setState(4);
                return;
            }
            if (this.state != 1) {
                return;
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDownload() throws IOException {
        int n;
        Object object;
        int n2;
        long l = System.currentTimeMillis();
        this.startTime = -1L;
        URLConnection uRLConnection = this.url.openConnection();
        int n3 = 0;
        this.resetUnsuccessfulAttempts = false;
        if (uRLConnection instanceof HttpURLConnection) {
            uRLConnection.setRequestProperty("Cache-Control", "no-transform");
            if (this.authorizationString != null) {
                uRLConnection.setRequestProperty("Authorization", "Basic " + this.authorizationString);
            }
            if (this.restartPosition > 0) {
                uRLConnection.setRequestProperty("Range", "bytes=" + this.restartPosition + "-");
            }
            try {
                uRLConnection.connect();
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Connection Error");
                iOException.initCause(exception);
                throw iOException;
            }
            int n4 = ((HttpURLConnection)uRLConnection).getResponseCode();
            if (n4 == 206) {
                n2 = 0;
                object = uRLConnection.getHeaderField("Content-Range");
                if (object != null && ((String)object).startsWith("bytes ") && (n = ((String)object).indexOf("-")) != -1) {
                    try {
                        n3 = Integer.parseInt(((String)object).substring(6, n));
                        n2 = 1;
                        if (n3 == this.restartPosition) {
                            this.resetUnsuccessfulAttempts = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n2 == 0) {
                    this.restartPosition = 0;
                    this.data = null;
                    this.setErrorMessage("Couldn't parse Content-Range");
                    return;
                }
            } else if (n4 != 200) {
                this.setState(4);
                this.setErrorMessage("HTTP response code " + n4);
                return;
            }
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.startPosition = n3;
            this.currentPosition = n3;
            this.startTime = l;
            n2 = uRLConnection.getContentLength();
            this.size = n2 > 0 ? this.startPosition + n2 : -1;
            this.markRestartPosition();
        }
        object2 = uRLConnection.getInputStream();
        n2 = 0;
        try {
            n2 = this.downloadData((InputStream)object2) ? 1 : 0;
        }
        finally {
            try {
                ((InputStream)object2).close();
            }
            catch (IOException iOException) {}
        }
        if (this.state == 1 && this.data != null && n2 != 0) {
            uRLConnection = this.url.openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                object = (HttpURLConnection)uRLConnection;
                ((HttpURLConnection)object).setRequestMethod("HEAD");
                ((URLConnection)object).setRequestProperty("Cache-Control", "no-transform");
                ((URLConnection)object).connect();
                if (((HttpURLConnection)object).getResponseCode() == 200) {
                    n = ((URLConnection)object).getContentLength();
                    if (this.data.length == n) {
                        this.setState(2);
                        return;
                    }
                    if (n <= 0) {
                        this.setState(2);
                        return;
                    }
                }
            } else {
                this.setState(2);
                return;
            }
            this.setState(4);
            this.setErrorMessage("HEAD request resulted in an unknown State");
        }
    }

    private final void setErrorMessage(String string) {
        this.lastException = new IOException(string);
    }

    private final int getCurrentPosition() {
        return this.currentPosition;
    }

    private final void increasePosition(int n) {
        if (n > 0) {
            this.currentPosition += n;
            if (this.resetUnsuccessfulAttempts) {
                this.unsuccessfulAttempts = 0;
                this.resetUnsuccessfulAttempts = false;
            }
        }
    }

    private final void markRestartPosition() {
        this.restartPosition = this.currentPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadData(InputStream inputStream) throws IOException {
        if (this.size == -1) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (this.startPosition > 0) {
                if (this.data == null || this.startPosition > this.data.length) {
                    this.setState(4);
                    this.setErrorMessage("Bad Content-Range");
                    return false;
                }
                byteArrayOutputStream.write(this.data, 0, this.startPosition);
            }
            this.data = null;
            byte[] byArray = new byte[1024];
            try {
                while (this.state == 1) {
                    int n = inputStream.read(byArray);
                    if (n == -1) {
                        boolean bl = true;
                        return bl;
                    }
                    if (n <= 0) continue;
                    this.increasePosition(n);
                    this.markRestartPosition();
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                this.data = byteArrayOutputStream.toByteArray();
            }
        } else {
            if (this.data == null) {
                this.data = new byte[this.size];
            } else if (this.data.length < this.size) {
                byte[] byArray = new byte[this.size];
                System.arraycopy(this.data, 0, byArray, 0, this.data.length);
                this.data = byArray;
            }
            while (this.state == 1) {
                int n = this.getCurrentPosition();
                int n2 = inputStream.read(this.data, n, Math.min(1024, this.size - n));
                if (n2 > 0) {
                    this.increasePosition(n2);
                    this.markRestartPosition();
                }
                if (this.getCurrentPosition() >= this.size) {
                    this.setState(2);
                    continue;
                }
                if (n2 != -1) continue;
                throw new IOException("Closed Prematurely");
            }
        }
        return false;
    }
}

