/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops.valuelists;

import java.util.ArrayList;
import java.util.List;
import org.softmed.jops.values.GenericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleGenericValueList<T> {
    int maxIndex;
    boolean random;
    int randomness;
    boolean active;
    int resolution = 30;
    boolean repeat;
    T nullValue;
    float lastTime = 0.0f;
    float dt;
    protected GenericValue previous = null;
    protected GenericValue next = null;
    protected List<GenericValue> values = new ArrayList<GenericValue>();
    T[] array;
    private int index;
    protected List<GenericValue> temp = new ArrayList<GenericValue>();
    protected List<GenericValue> ordered = new ArrayList<GenericValue>();
    protected List<T> elements = new ArrayList<T>();

    public abstract T calculateResult(T var1, T var2, float var3, float var4);

    public T getValueAt(float f) {
        if (f > this.lastTime) {
            f = this.repeat ? (f %= this.lastTime) : this.lastTime;
        }
        this.index = (int)(f * (float)this.resolution);
        try {
            if (this.index >= this.array.length) {
                this.index = this.array.length - 1;
            }
            return this.array[this.index];
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setValue(T t, float f) {
        for (int i = 0; i < this.values.size(); ++i) {
            GenericValue genericValue = this.values.get(i);
            if (genericValue.time != f) continue;
            genericValue.value = t;
            this.compileArray();
            return;
        }
        GenericValue genericValue = new GenericValue(t, f);
        this.values.add(genericValue);
        this.compileArray();
    }

    public void setValue(GenericValue genericValue) {
        this.values.add(genericValue);
        this.compileArray();
    }

    public void removeValue(float f) {
        for (int i = 0; i < this.values.size(); ++i) {
            GenericValue genericValue = this.values.get(i);
            if (genericValue.time != f) continue;
            this.values.remove(genericValue);
            break;
        }
        this.compileArray();
    }

    public void compileArray() {
        this.orderList();
        this.values.clear();
        this.values.addAll(this.ordered);
        this.createArray();
        this.lastTime = this.values.get((int)(this.values.size() - 1)).time;
        this.maxIndex = (int)(this.lastTime * (float)this.resolution);
        float f = this.lastTime;
    }

    private void createArray() {
        GenericValue genericValue = null;
        GenericValue genericValue2 = null;
        this.elements = new ArrayList<T>();
        for (int i = 0; i < this.ordered.size(); ++i) {
            genericValue = this.ordered.get(i);
            genericValue2 = i + 1 < this.ordered.size() ? this.ordered.get(i + 1) : null;
            this.createArrayElements(genericValue, genericValue2);
        }
        this.array = this.elements.toArray();
    }

    private void createArrayElements(GenericValue genericValue, GenericValue genericValue2) {
        if (genericValue2 == null) {
            this.elements.add(genericValue.value);
            return;
        }
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        if (genericValue2 != null) {
            f = genericValue2.time - genericValue.time;
            n = (int)(f * (float)this.resolution);
        }
        float f2 = 0.0f;
        for (int i = n2; i < n; ++i) {
            f2 = (float)i / (float)this.resolution;
            this.elements.add(this.calculateResult(genericValue.value, genericValue2.value, f2, f));
        }
    }

    protected List<GenericValue> orderList() {
        if (this.temp != null) {
            this.temp.clear();
        } else {
            this.temp = new ArrayList<GenericValue>();
        }
        if (this.ordered != null) {
            this.ordered.clear();
        } else {
            this.ordered = new ArrayList<GenericValue>();
        }
        this.temp.addAll(this.values);
        GenericValue genericValue = null;
        GenericValue genericValue2 = null;
        while (this.temp.size() > 0) {
            genericValue2 = null;
            for (int i = 0; i < this.temp.size(); ++i) {
                genericValue = this.temp.get(i);
                if (genericValue2 != null && !(genericValue.time < genericValue2.time)) continue;
                genericValue2 = genericValue;
            }
            this.temp.remove(genericValue2);
            this.ordered.add(genericValue2);
        }
        return this.ordered;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean bl) {
        this.repeat = bl;
    }

    public List<GenericValue> getValues() {
        return this.values;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int n) {
        this.resolution = n;
    }

    public T getNullValue() {
        return this.nullValue;
    }

    public void setValues(List<GenericValue> list) {
        this.values = list;
        list.remove(0);
        this.compileArray();
    }
}

