/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops.fileloading;

import org.jibx.runtime.IAliasable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.softmed.jops.fileloading.SimpleColorConverter;
import org.softmed.jops.fileloading.SimplePointConverter;
import org.softmed.jops.fileloading.SimpleVectorConverter;

public class ObjectMarshaller
implements IMarshaller,
IUnmarshaller,
IAliasable {
    private String m_uri;
    private int m_index;
    private String m_name;
    String TYPE = "type";
    String FLOAT = "float";
    String COLOR = "color";
    String VECTOR = "vector";
    String POINT = "point";
    SimpleColorConverter colorConverter = new SimpleColorConverter();
    SimpleVectorConverter vectorConverter = new SimpleVectorConverter();
    SimplePointConverter pointConverter = new SimplePointConverter();

    public ObjectMarshaller() {
        this.m_uri = null;
        this.m_index = 0;
        this.m_name = "hashmap";
    }

    public ObjectMarshaller(String string, int n, String string2) {
        this.m_uri = string;
        this.m_index = n;
        this.m_name = string2;
    }

    public boolean isExtension(int n) {
        return false;
    }

    public boolean isPresent(IUnmarshallingContext iUnmarshallingContext) throws JiBXException {
        return iUnmarshallingContext.isAt(this.m_uri, this.m_name);
    }

    public void marshal(Object object, IMarshallingContext iMarshallingContext) throws JiBXException {
        if (object instanceof Float) {
            MarshallingContext marshallingContext = (MarshallingContext)iMarshallingContext;
            marshallingContext.startTagAttributes(this.m_index, this.m_name).attribute(this.m_index, this.TYPE, this.FLOAT).closeStartContent();
            marshallingContext.content(((Float)object).toString());
            marshallingContext.endTag(this.m_index, this.m_name);
        } else if (object instanceof Colorf) {
            MarshallingContext marshallingContext = (MarshallingContext)iMarshallingContext;
            marshallingContext.startTagAttributes(this.m_index, this.m_name).attribute(this.m_index, this.TYPE, this.COLOR).closeStartContent();
            marshallingContext.content(this.colorConverter.toString(object));
            marshallingContext.endTag(this.m_index, this.m_name);
        } else if (object instanceof Vector3f) {
            MarshallingContext marshallingContext = (MarshallingContext)iMarshallingContext;
            marshallingContext.startTagAttributes(this.m_index, this.m_name).attribute(this.m_index, this.TYPE, this.VECTOR).closeStartContent();
            marshallingContext.content(this.vectorConverter.toString(object));
            marshallingContext.endTag(this.m_index, this.m_name);
        } else if (object instanceof Point3f) {
            MarshallingContext marshallingContext = (MarshallingContext)iMarshallingContext;
            marshallingContext.startTagAttributes(this.m_index, this.m_name).attribute(this.m_index, this.TYPE, this.POINT).closeStartContent();
            marshallingContext.content(this.pointConverter.toString(object));
            marshallingContext.endTag(this.m_index, this.m_name);
        }
    }

    public Object unmarshal(Object object, IUnmarshallingContext iUnmarshallingContext) throws JiBXException {
        UnmarshallingContext unmarshallingContext = (UnmarshallingContext)iUnmarshallingContext;
        if (!unmarshallingContext.isAt(this.m_uri, this.m_name)) {
            unmarshallingContext.throwStartTagNameError(this.m_uri, this.m_name);
        }
        unmarshallingContext.parseToStartTag(this.m_uri, this.m_name);
        String string = unmarshallingContext.attributeText(this.m_uri, this.TYPE);
        unmarshallingContext.parsePastStartTag(this.m_uri, this.m_name);
        String string2 = unmarshallingContext.parseContentText();
        unmarshallingContext.parsePastEndTag(this.m_uri, this.m_name);
        Object object2 = null;
        if (string.equals(this.FLOAT)) {
            object2 = new Float(string2);
        } else if (string.equals(this.COLOR)) {
            object2 = this.colorConverter.fromString(string2);
        } else if (string.equals(this.VECTOR)) {
            object2 = this.vectorConverter.fromString(string2);
        } else if (string.equals(this.POINT)) {
            object2 = this.pointConverter.fromString(string2);
        }
        return object2;
    }
}

