/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.NondirectBufferWrapper;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.GLSync;

public final class ARBSync {
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;

    private ARBSync() {
    }

    public static GLSync glFenceSync(int condition, int flags) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_sync_glFenceSync_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLSync __result = new GLSync(ARBSync.nglFenceSync(condition, flags, function_pointer));
        return __result;
    }

    private static native long nglFenceSync(int var0, int var1, long var2);

    public static boolean glIsSync(GLSync sync) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_sync_glIsSync_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        boolean __result = ARBSync.nglIsSync(sync.getPointer(), function_pointer);
        return __result;
    }

    private static native boolean nglIsSync(long var0, long var2);

    public static void glDeleteSync(GLSync sync) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_sync_glDeleteSync_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBSync.nglDeleteSync(sync.getPointer(), function_pointer);
    }

    private static native void nglDeleteSync(long var0, long var2);

    public static int glClientWaitSync(GLSync sync, int flags, long timeout) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_sync_glClientWaitSync_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        int __result = ARBSync.nglClientWaitSync(sync.getPointer(), flags, timeout, function_pointer);
        return __result;
    }

    private static native int nglClientWaitSync(long var0, int var2, long var3, long var5);

    public static void glWaitSync(GLSync sync, int flags, long timeout) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_sync_glWaitSync_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBSync.nglWaitSync(sync.getPointer(), flags, timeout, function_pointer);
    }

    private static native void nglWaitSync(long var0, int var2, long var3, long var5);

    public static void glGetInteger64(int pname, LongBuffer params) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_sync_glGetInteger64v_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        LongBuffer params_saved = params;
        params = NondirectBufferWrapper.wrapNoCopyBuffer(params, 1);
        ARBSync.nglGetInteger64v(pname, params, params.position(), function_pointer);
        NondirectBufferWrapper.copy(params, params_saved);
    }

    private static native void nglGetInteger64v(int var0, LongBuffer var1, int var2, long var3);

    public static void glGetSynciv(GLSync sync, int pname, IntBuffer length, IntBuffer values) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.ARB_sync_glGetSynciv_pointer;
        BufferChecks.checkFunctionAddress(function_pointer);
        IntBuffer length_saved = length;
        if (length != null) {
            length = NondirectBufferWrapper.wrapNoCopyBuffer(length, 1);
        }
        IntBuffer values_saved = values;
        values = NondirectBufferWrapper.wrapNoCopyDirect(values);
        ARBSync.nglGetSynciv(sync.getPointer(), pname, values.remaining(), length, length != null ? length.position() : 0, values, values.position(), function_pointer);
        NondirectBufferWrapper.copy(length, length_saved);
        NondirectBufferWrapper.copy(values, values_saved);
    }

    private static native void nglGetSynciv(long var0, int var2, int var3, IntBuffer var4, int var5, IntBuffer var6, int var7, long var8);
}

