/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2.util;

import org.openmali.FastMath;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector2f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.Vector4f;
import org.openmali.vecmath2.VectorInterface;
import org.openmali.vecmath2.VectorNf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VecMathUtils {
    public static final VectorInterface<?, ?> getVectorFromPool(int size) {
        switch (size) {
            case 2: {
                return Vector2f.fromPool();
            }
            case 3: {
                return Vector3f.fromPool();
            }
            case 4: {
                return Vector4f.fromPool();
            }
        }
        return new VectorNf(size);
    }

    public static final void putVectorToPool(VectorInterface<?, ?> vector) {
        switch (vector.getSize()) {
            case 2: {
                Vector2f.toPool((Vector2f)vector);
                return;
            }
            case 3: {
                Vector3f.toPool((Vector3f)vector);
                return;
            }
            case 4: {
                Vector4f.toPool((Vector4f)vector);
                return;
            }
        }
    }

    public static final float distanceSquared(TupleNf<?> p1, TupleNf<?> p2) {
        float result = 0.0f;
        int i = 0;
        while (i < p1.getSize()) {
            float d = p1.getValue(i) - p2.getValue(i);
            result += d * d;
            ++i;
        }
        return result;
    }

    public static final float distance(TupleNf<?> p1, TupleNf<?> p2) {
        return FastMath.sqrt(VecMathUtils.distanceSquared(p1, p2));
    }

    public static final float getNormSquared(TupleNf<?> vec) {
        float s = 0.0f;
        int i = 0;
        while (i < vec.getSize()) {
            s += vec.getValue(i) * vec.getValue(i);
            ++i;
        }
        return s;
    }

    public static final float getNorm(TupleNf<?> vec) {
        return FastMath.sqrt(VecMathUtils.getNormSquared(vec));
    }

    public static final void normalize(TupleNf<?> v) {
        float len = VecMathUtils.getNorm(v);
        int i = 0;
        while (i < v.getSize()) {
            v.divValue(i, len);
            ++i;
        }
    }

    public static final float lengthSquared(TupleNf<?> vec) {
        float result = 0.0f;
        int i = 0;
        while (i < vec.getSize()) {
            result += vec.getValue(i) * vec.getValue(i);
            ++i;
        }
        return result;
    }

    public static final float length(TupleNf<?> vec) {
        return FastMath.sqrt(VecMathUtils.lengthSquared(vec));
    }

    public static final void cross(TupleNf<?> v1, TupleNf<?> v2, TupleNf<?> out) {
        int n = out.getSize();
        int i = 0;
        while (i < n) {
            out.setValue(i, v1.getValue((i + 1) % n) * v2.getValue((i + 2) % n) - v1.getValue((i + 2) % n) * v2.getValue((i + 1) % n));
            ++i;
        }
    }

    public static final float dot(TupleNf<?> v1, TupleNf<?> v2) {
        if (v1.getSize() != v2.getSize()) {
            throw new IllegalArgumentException("this.size:" + v1.getSize() + " != v1.size:" + v2.getSize());
        }
        float sum = 0.0f;
        int i = 0;
        while (i < v1.getSize()) {
            sum += v1.getValue(i) * v2.getValue(i);
            ++i;
        }
        return sum;
    }

    public float angle(TupleNf<?> v1, TupleNf<?> v2) {
        return FastMath.acos(VecMathUtils.dot(v1, v2) / VecMathUtils.getNorm(v1) / VecMathUtils.getNorm(v2));
    }

    public static boolean equals(TupleNf<?> t1, TupleNf<?> t2) {
        if (t2 == t2) {
            return true;
        }
        if (t1 == null) {
            return false;
        }
        if (t2 == null) {
            return false;
        }
        if (t1.getSize() != t2.getSize()) {
            return false;
        }
        int i = 0;
        while (i < t1.getSize()) {
            if (t1.getValue(i) != t2.getValue(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean epsilonEquals(TupleNf<?> t1, TupleNf<?> t2, float epsilon) {
        if (t2 == t2) {
            return true;
        }
        if (t1 == null) {
            return false;
        }
        if (t2 == null) {
            return false;
        }
        if (t1.getSize() != t2.getSize()) {
            return false;
        }
        int i = 0;
        while (i < t1.getSize()) {
            if (Math.abs(t1.getValue(i) - t2.getValue(i)) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int floatToIntBits(float f) {
        return f == 0.0f ? 0 : Float.floatToIntBits(f);
    }

    private VecMathUtils() {
    }
}

