/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class SerializationUtils {
    public static final void writeToBuffer(int i, int pos, byte[] buffer) {
        buffer[pos + 0] = (byte)(i >> 24);
        buffer[pos + 1] = (byte)(i >> 16);
        buffer[pos + 2] = (byte)(i >> 8);
        buffer[pos + 3] = (byte)(i >> 0);
    }

    public static final void writeToBuffer(int[] ints, int start, int length, int pos, byte[] buffer) {
        int end = start + length;
        int i = start;
        while (i < end) {
            SerializationUtils.writeToBuffer(ints[i], pos, buffer);
            pos += 4;
            ++i;
        }
    }

    public static final void writeToBuffer(int[] ints, int pos, byte[] buffer) {
        SerializationUtils.writeToBuffer(ints, 0, ints.length, pos, buffer);
    }

    public static final void writeToBuffer(float f, int pos, byte[] buffer) {
        SerializationUtils.writeToBuffer(Float.floatToRawIntBits(f), pos, buffer);
    }

    public static final void writeToBuffer(float[] floats, int start, int length, int pos, byte[] buffer) {
        int end = start + length;
        int i = start;
        while (i < end) {
            SerializationUtils.writeToBuffer(floats[i], pos, buffer);
            pos += 4;
            ++i;
        }
    }

    public static final void writeToBuffer(float[] floats, int pos, byte[] buffer) {
        SerializationUtils.writeToBuffer(floats, 0, floats.length, pos, buffer);
    }

    public static final void writeToBuffer(boolean b, int pos, byte[] buffer) {
        buffer[pos] = (byte)(b ? 1 : 0);
    }

    public static final void writeToBuffer(boolean[] bools, int start, int length, int pos, byte[] buffer) {
        int end = start + length;
        int i = start;
        while (i < end) {
            SerializationUtils.writeToBuffer(bools[i], pos, buffer);
            ++pos;
            ++i;
        }
    }

    public static final void writeToBuffer(boolean[] bools, int pos, byte[] buffer) {
        SerializationUtils.writeToBuffer(bools, 0, bools.length, pos, buffer);
    }

    public static final int readIntFromBuffer(int pos, byte[] buffer) {
        int byte3 = (buffer[pos + 0] & 0xFF) << 24;
        int byte2 = (buffer[pos + 1] & 0xFF) << 16;
        int byte1 = (buffer[pos + 2] & 0xFF) << 8;
        int byte0 = (buffer[pos + 3] & 0xFF) << 0;
        return byte3 + byte2 + byte1 + byte0;
    }

    public static final void readIntsFromBuffer(int pos, byte[] buffer, int[] out, int start, int length) {
        int end = start + length;
        int i = start;
        while (i < end) {
            out[i] = SerializationUtils.readIntFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
    }

    public static final void readIntsFromBuffer(int pos, byte[] buffer, int[] out) {
        SerializationUtils.readIntsFromBuffer(pos, buffer, out, 0, out.length);
    }

    public static final float readFloatFromBuffer(int pos, byte[] buffer) {
        return Float.intBitsToFloat(SerializationUtils.readIntFromBuffer(pos, buffer));
    }

    public static final void readFloatsFromBuffer(int pos, byte[] buffer, float[] out, int start, int length) {
        int end = start + length;
        int i = start;
        while (i < end) {
            out[i] = SerializationUtils.readFloatFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
    }

    public static final void readFloatsFromBuffer(int pos, byte[] buffer, float[] out) {
        SerializationUtils.readFloatsFromBuffer(pos, buffer, out, 0, out.length);
    }

    public static final boolean readBoolFromBuffer(int pos, byte[] buffer) {
        return (buffer[pos] & 0xFF) != 0;
    }

    public static final void readBoolsFromBuffer(int pos, byte[] buffer, boolean[] out, int start, int length) {
        int end = start + length;
        int i = start;
        while (i < end) {
            out[i] = SerializationUtils.readBoolFromBuffer(pos, buffer);
            ++pos;
            ++i;
        }
    }

    public static final void readBoolsFromBuffer(int pos, byte[] buffer, boolean[] out) {
        SerializationUtils.readBoolsFromBuffer(pos, buffer, out, 0, out.length);
    }

    public static void saveObject(Object object, OutputStream out) throws IOException {
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("The object is not Serializable!");
        }
        new ObjectOutputStream(out).writeObject(object);
    }

    public static void saveObject(Object object, String filename) throws IOException {
        SerializationUtils.saveObject(object, new FileOutputStream(filename));
    }

    public static void saveObject(Object object, File file) throws IOException {
        SerializationUtils.saveObject(object, new FileOutputStream(file));
    }

    public static Object loadObject(InputStream in) throws IOException, ClassNotFoundException {
        return new ObjectInputStream(in).readObject();
    }

    public static Object loadObject(String filename) throws IOException, ClassNotFoundException {
        return SerializationUtils.loadObject(new FileInputStream(filename));
    }

    public static Object loadObject(File file) throws IOException, ClassNotFoundException {
        return SerializationUtils.loadObject(new FileInputStream(file));
    }
}

