/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2.util;

import org.openmali.FastMath;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class Interpolation {
    private static Vector3f speed = new Vector3f();
    private static final float NEIGHBORHOOD = 0.959066f;
    private static final float SCALE = 1.000311f;
    private static final float ADDITIVE_CONSTANT = 1.000311f / FastMath.sqrt(0.959066f);
    private static final float FACTOR = 1.000311f * (-0.5f / (0.959066f * FastMath.sqrt(0.959066f)));

    public static final void nlerp(Quaternion4f toInterpolate, Quaternion4f quatOrigin, Quaternion4f quatDestiny, float delta) {
        Quaternion4f res = new Quaternion4f(quatDestiny);
        res.sub(quatOrigin);
        res.scale(delta);
        res.add(quatOrigin);
        toInterpolate.set((TupleNf)Interpolation.fastNormalize(res));
    }

    public static Quaternion4f fastNormalize(Quaternion4f quat) {
        float s = quat.getA() * quat.getA() + quat.getB() * quat.getB() + quat.getC() * quat.getC() + quat.getD() * quat.getD();
        float k = Interpolation.isqrtApproxInNeighborhood(s);
        if (s < 0.83042395f) {
            k *= Interpolation.isqrtApproxInNeighborhood(s);
            if (s < 0.30174562f) {
                k *= Interpolation.isqrtApproxInNeighborhood(s);
            }
        }
        quat.mul(k);
        return quat;
    }

    private static float isqrtApproxInNeighborhood(float s) {
        return ADDITIVE_CONSTANT + FACTOR * (s - 0.959066f);
    }

    private static Quaternion4f normalize(Quaternion4f quat4f) {
        float lengthSq = quat4f.getA() * quat4f.getA() + quat4f.getB() * quat4f.getB() + quat4f.getC() * quat4f.getC() + quat4f.getD() * quat4f.getD();
        if (lengthSq == 0.0f) {
            return quat4f;
        }
        if (lengthSq != 1.0f) {
            float scale = 1.0f / FastMath.sqrt(lengthSq);
            quat4f.mul(scale);
        }
        return quat4f;
    }

    private static final void slerp(Quaternion4f toInterpolate, Quaternion4f quatOrigin, Quaternion4f quatDestiny, float deltaT) {
        float sign;
        float dot = quatOrigin.getA() * quatDestiny.getA() + quatOrigin.getB() * quatDestiny.getB() + quatOrigin.getC() * quatDestiny.getC() + quatOrigin.getD() * quatDestiny.getD();
        if (dot < 0.0f) {
            dot = -dot;
            sign = -1.0f;
        } else {
            sign = 1.0f;
        }
        if (dot >= 0.99999f) {
            toInterpolate.set((TupleNf)quatOrigin);
            return;
        }
        float angle = FastMath.acos(dot);
        float denom = FastMath.sin(angle);
        float weight1 = FastMath.sin((1.0f - deltaT) * angle) / denom;
        float weight2 = sign * FastMath.sin(deltaT * angle) / denom;
        toInterpolate.set(weight1 * quatOrigin.getA() + weight2 * quatDestiny.getA(), weight1 * quatOrigin.getB() + weight2 * quatDestiny.getB(), weight1 * quatOrigin.getC() + weight2 * quatDestiny.getC(), weight1 * quatOrigin.getD() + weight2 * quatDestiny.getD());
    }

    public static void interpolate(Tuple3f toInterpolate, Tuple3f tupleOrigin, Tuple3f tupleDestiny, float delta) {
        speed.set((TupleNf)tupleDestiny);
        speed.sub(tupleOrigin);
        speed.scale(delta);
        toInterpolate.set((TupleNf)tupleOrigin);
        toInterpolate.add(speed);
    }
}

