/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2.util;

import org.openmali.vecmath2.Colorf;

public final class ColorUtil {
    public static final int hexToInt(char ch) {
        if (ch >= 'A' && ch <= 'Z') {
            return ch - 55;
        }
        if (ch >= 'a' && ch <= 'z') {
            return ch - 87;
        }
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        return -1;
    }

    private static final int calcColorComp(String str, int start) {
        int h = ColorUtil.hexToInt(str.charAt(start + 0));
        int l = ColorUtil.hexToInt(str.charAt(start + 1));
        return h * 16 + l;
    }

    private static final void checkHexString(String hexStr) {
        if (hexStr == null) {
            throw new NullPointerException("hexStr");
        }
        if (!(hexStr.length() == 6 || hexStr.length() == 7 && hexStr.startsWith("#"))) {
            throw new IllegalArgumentException("The hex-String must either have a length of 6 or of 7 and must start with '#'.");
        }
    }

    public static final void hexToColor(String hexStr, float[] buffer) {
        ColorUtil.checkHexString(hexStr);
        int start = hexStr.startsWith("#") ? 1 : 0;
        buffer[0] = (float)ColorUtil.calcColorComp(hexStr, start + 0) / 255.0f;
        buffer[1] = (float)ColorUtil.calcColorComp(hexStr, start + 2) / 255.0f;
        buffer[2] = (float)ColorUtil.calcColorComp(hexStr, start + 4) / 255.0f;
    }

    public static final Colorf hexToColor(String hexStr, Colorf out) {
        ColorUtil.checkHexString(hexStr);
        int start = hexStr.startsWith("#") ? 1 : 0;
        out.setRed((float)ColorUtil.calcColorComp(hexStr, start + 0) / 255.0f);
        out.setGreen((float)ColorUtil.calcColorComp(hexStr, start + 2) / 255.0f);
        out.setBlue((float)ColorUtil.calcColorComp(hexStr, start + 4) / 255.0f);
        return out;
    }

    public static final Colorf hexToColor(String hexStr) {
        float[] values = new float[4];
        values[3] = 0.0f;
        ColorUtil.hexToColor(hexStr, values);
        return new Colorf(values);
    }

    private static final String pad2(String s) {
        if (s.length() >= 2) {
            return s;
        }
        int i = s.length();
        while (i < 2) {
            s = "0" + s;
            ++i;
        }
        return s;
    }

    public static final String colorToHex(Colorf color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        String value = "#";
        value = String.valueOf(value) + ColorUtil.pad2(Integer.toHexString((int)(255.0f * color.getRed())).toUpperCase());
        value = String.valueOf(value) + ColorUtil.pad2(Integer.toHexString((int)(255.0f * color.getGreen())).toUpperCase());
        value = String.valueOf(value) + ColorUtil.pad2(Integer.toHexString((int)(255.0f * color.getBlue())).toUpperCase());
        return value;
    }

    private ColorUtil() {
    }
}

