/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.openmali.FastMath;
import org.openmali.vecmath2.TupleInterface;
import org.openmali.vecmath2.util.SerializationUtils;
import org.openmali.vecmath2.util.VecMathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TupleNf<T extends TupleNf<?>>
implements TupleInterface<T> {
    private final int N;
    protected final float[] values;
    protected final int roTrick;
    protected boolean isDirty = false;
    private static final StringBuffer TMP_SB = new StringBuffer();

    @Override
    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    @Override
    public final boolean setClean() {
        boolean oldValue = this.isDirty;
        this.isDirty = false;
        return oldValue;
    }

    @Override
    public final boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public final int getSize() {
        return this.N;
    }

    @Override
    public final TupleNf<T> setValue(int i, float v) {
        this.values[this.roTrick + i] = v;
        this.isDirty = true;
        return this;
    }

    @Override
    public final float getValue(int i) {
        return this.values[i];
    }

    public final FloatBuffer writeToBuffer(FloatBuffer buffer) {
        buffer.clear();
        buffer.put(this.values);
        buffer.flip();
        return buffer;
    }

    public static final FloatBuffer writeToBuffer(TupleNf<?>[] tuples, FloatBuffer buffer) {
        buffer.clear();
        int i = 0;
        while (i < tuples.length) {
            buffer.put(tuples[i].values);
            ++i;
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public final TupleNf<T> fill(float f) {
        Arrays.fill(this.values, this.roTrick + 0, this.getSize(), f);
        this.isDirty = true;
        return this;
    }

    @Override
    public final TupleNf<T> addValue(int i, float v) {
        int n = this.roTrick + i;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    @Override
    public final TupleNf<T> subValue(int i, float v) {
        int n = this.roTrick + i;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    @Override
    public final TupleNf<T> mulValue(int i, float v) {
        int n = this.roTrick + i;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    @Override
    public final TupleNf<T> mul(float v) {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = this.values[n] * v;
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    @Override
    public final TupleNf<T> divValue(int i, float v) {
        int n = this.roTrick + i;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    @Override
    public final TupleNf<T> div(float v) {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = this.values[n] / v;
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    @Override
    public TupleNf<T> set(float[] values) {
        System.arraycopy(values, 0, this.values, this.roTrick + 0, this.N);
        this.isDirty = true;
        return this;
    }

    @Override
    public final TupleNf<T> set(TupleNf<?> tuple) {
        System.arraycopy(tuple.values, 0, this.values, this.roTrick + 0, Math.min(this.getSize(), tuple.getSize()));
        this.isDirty = true;
        return this;
    }

    @Override
    public void get(float[] buffer) {
        System.arraycopy(this.values, 0, buffer, 0, this.N);
    }

    @Override
    public final void get(TupleNf<?> buffer) {
        System.arraycopy(this.values, 0, buffer.values, 0, Math.min(this.getSize(), buffer.getSize()));
    }

    @Override
    public final TupleNf<T> setZero() {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, 0.0f);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> negate() {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, -this.values[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> negate(T tuple) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, -((TupleNf)tuple).values[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> absolute() {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, Math.abs(this.values[i]));
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> absolute(T tuple) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, Math.abs(((TupleNf)tuple).values[i]));
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> add(T tuple1, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, ((TupleNf)tuple1).values[i] + ((TupleNf)tuple2).values[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> add(T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, this.values[i] + ((TupleNf)tuple2).values[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> sub(T tuple1, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, ((TupleNf)tuple1).values[i] - ((TupleNf)tuple2).values[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> sub(T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.subValue(i, ((TupleNf)tuple2).values[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> scale(float factor, T tuple) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, factor * ((TupleNf)tuple).values[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> scale(float factor) {
        int i = 0;
        while (i < this.N) {
            this.mulValue(i, factor);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> scaleAdd(float factor, T tuple1, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, factor * ((TupleNf)tuple1).values[i] + ((TupleNf)tuple2).values[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> scaleAdd(float factor, T tuple2) {
        int i = 0;
        while (i < this.N) {
            this.setValue(i, factor * this.values[i] + ((TupleNf)tuple2).values[i]);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> clampMin(float min) {
        int i = 0;
        while (i < this.N) {
            if (this.values[i] < min) {
                this.setValue(i, min);
            }
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> clampMax(float max) {
        int i = 0;
        while (i < this.N) {
            if (this.getValue(i) > max) {
                this.setValue(i, max);
            }
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> clamp(float min, float max) {
        this.clampMin(min);
        this.clampMax(max);
        return this;
    }

    @Override
    public final TupleNf<T> clamp(float min, float max, T tuple) {
        this.set((TupleNf)tuple);
        this.clamp(min, max);
        return this;
    }

    @Override
    public final TupleNf<T> clampMin(float min, T tuple) {
        this.set((TupleNf)tuple);
        this.clampMin(min);
        return this;
    }

    @Override
    public final TupleNf<T> clampMax(float max, T tuple) {
        this.set((TupleNf)tuple);
        this.clampMax(max);
        return this;
    }

    @Override
    public final TupleNf<T> round(T tuple, int decPlaces) {
        float pow = FastMath.pow(10.0f, (float)decPlaces);
        int i = 0;
        while (i < this.N) {
            this.setValue(i, (float)((int)(((TupleNf)tuple).getValue(i) * pow)) / pow);
            ++i;
        }
        return this;
    }

    @Override
    public final TupleNf<T> round(int decPlaces) {
        float pow = FastMath.pow(10.0f, (float)decPlaces);
        int i = 0;
        while (i < this.N) {
            this.setValue(i, (float)((int)(this.getValue(i) * pow)) / pow);
            ++i;
        }
        return this;
    }

    @Override
    public void interpolate(T t2, float alpha) {
        float beta = 1.0f - alpha;
        int i = 0;
        while (i < this.N) {
            this.setValue(i, beta * this.getValue(i) + alpha * ((TupleNf)t2).getValue(i));
            ++i;
        }
    }

    @Override
    public final void interpolate(T t1, T t2, float alpha) {
        this.set((TupleNf)t1);
        this.interpolate(t2, alpha);
    }

    public boolean equals(T v2) {
        if (v2 == null) {
            return false;
        }
        if (this.N != ((TupleNf)v2).N) {
            return false;
        }
        int i = 0;
        while (i < this.N) {
            if (this.getValue(i) != ((TupleNf)v2).getValue(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            return this.equals((T)((TupleNf)o));
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean epsilonEquals(T v2, float epsilon) {
        if (this.N != ((TupleNf)v2).N) {
            return false;
        }
        int i = 0;
        while (i < this.N) {
            if (Math.abs(this.getValue(i) - ((TupleNf)v2).getValue(i)) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.N) {
            int bits = VecMathUtils.floatToIntBits(this.getValue(i));
            hash ^= bits ^ bits >> 32;
            ++i;
        }
        return hash;
    }

    public String toString() {
        TMP_SB.setLength(0);
        TMP_SB.append("( ");
        int i = 0;
        while (i < this.N - 1) {
            TMP_SB.append(this.getValue(i));
            TMP_SB.append(", ");
            ++i;
        }
        TMP_SB.append(this.getValue(this.N - 1));
        TMP_SB.append(" )");
        return String.valueOf(this.getClass().getSimpleName()) + TMP_SB.toString();
    }

    public int serialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.N) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.isDirty, pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.N) {
            this.values[i] = SerializationUtils.readFloatFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.isDirty = SerializationUtils.readBoolFromBuffer(pos, buffer);
        return ++pos;
    }

    protected int getSerializationBufferSize() {
        return 4 * this.N + 1;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    protected TupleNf(boolean readOnly, int n) {
        this.N = n;
        this.values = new float[n];
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
    }

    protected TupleNf(boolean readOnly, float[] values, int n, boolean copy) {
        this.N = n;
        if (copy) {
            this.values = new float[n];
            System.arraycopy(values, 0, this.values, 0, this.N);
        } else {
            this.values = values;
        }
        this.roTrick = readOnly ? -2147483647 + values.length : 0;
    }

    protected TupleNf(boolean readOnly, float[] values, int n) {
        this(readOnly, values, n, true);
    }

    protected TupleNf(boolean readOnly, TupleNf<?> that) {
        this(readOnly, that.values, that.values.length, true);
    }

    public TupleNf(int n) {
        this(false, n);
    }

    public TupleNf(float[] values, int n, boolean copy) {
        this(false, values, n, copy);
    }

    public TupleNf(float[] values, int n) {
        this(false, values, n);
    }

    public TupleNf(TupleNf<?> that) {
        this(false, that);
    }
}

