/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openmali.vecmath2.pools.Tuple2iPool;
import org.openmali.vecmath2.util.SerializationUtils;

public class Tuple2i
implements Externalizable {
    private static final long serialVersionUID = 586023996166921455L;
    private static final Tuple2iPool POOL = new Tuple2iPool(128);
    protected static final int N = 2;
    protected final int[] values;
    protected final int roTrick;
    private boolean isDirty = false;

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        boolean oldValue = this.isDirty;
        this.isDirty = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final int getSize() {
        return 2;
    }

    public final Tuple2i setValue(int i, int v) {
        this.values[this.roTrick + i] = v;
        this.isDirty = true;
        return this;
    }

    public final int getValue(int i) {
        return this.values[i];
    }

    public final Tuple2i setX(int x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple2i setY(int y) {
        this.setValue(1, y);
        return this;
    }

    public final int getX() {
        return this.getValue(0);
    }

    public final int getY() {
        return this.getValue(1);
    }

    public final Tuple2i set(int x, int y) {
        this.setX(x);
        this.setY(y);
        return this;
    }

    public final Tuple2i set(int[] values) {
        System.arraycopy(values, 0, this.values, this.roTrick + 0, 2);
        this.isDirty = true;
        return this;
    }

    public final Tuple2i set(Tuple2i tuple) {
        System.arraycopy(tuple.values, 0, this.values, this.roTrick + 0, 2);
        return this;
    }

    public final void get(int[] buffer) {
        System.arraycopy(this.values, 0, buffer, 0, 2);
    }

    public final void get(Tuple2i buffer) {
        System.arraycopy(this.values, 0, buffer.values, 0, 2);
    }

    public final Tuple2i setZero() {
        int i = 0;
        while (i < this.getSize()) {
            this.setValue(i, 0);
            ++i;
        }
        return this;
    }

    public final Tuple2i negate(Tuple2i tuple) {
        this.setX(-tuple.getX());
        this.setY(-tuple.getY());
        return this;
    }

    public final Tuple2i negate() {
        int i = 0;
        while (i < 2) {
            int n = this.roTrick + i;
            this.values[n] = (int)((float)this.values[n] * -1.0f);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple2i absolute() {
        int i = 0;
        while (i < 2) {
            this.values[this.roTrick + i] = Math.abs(this.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple2i absolute(Tuple2i tuple) {
        int i = 0;
        while (i < 2) {
            this.values[this.roTrick + i] = Math.abs(tuple.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple2i addX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i addY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i add(int x, int y) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + y;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i subX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i subY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i sub(int x, int y) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - y;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i mulX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i mulY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i mul(int vx, int vy) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vy;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i divX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i divY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i div(int vx, int vy) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vy;
        this.isDirty = true;
        return this;
    }

    public final Tuple2i add(Tuple2i tuple1, Tuple2i tuple2) {
        int i = 0;
        while (i < 2) {
            this.setValue(i, tuple1.getValue(i) + tuple2.getValue(i));
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple2i add(Tuple2i tuple2) {
        int i = 0;
        while (i < 2) {
            this.setValue(i, this.getValue(i) + tuple2.getValue(i));
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple2i sub(Tuple2i tuple1, Tuple2i tuple2) {
        int i = 0;
        while (i < 2) {
            this.setValue(i, tuple1.values[i] - tuple2.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple2i sub(Tuple2i tuple2) {
        int i = 0;
        while (i < 2) {
            this.setValue(i, this.values[i] - tuple2.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple2i scale(int factorX, int factorY) {
        this.mul(factorX, factorY);
        return this;
    }

    public final Tuple2i scale(int factor, Tuple2i tuple) {
        int i = 0;
        while (i < 2) {
            this.setValue(i, factor * tuple.values[i]);
            ++i;
        }
        return this;
    }

    public final Tuple2i scale(int factor) {
        int i = 0;
        while (i < 2) {
            this.setValue(i, this.getValue(i) * factor);
            ++i;
        }
        return this;
    }

    public final Tuple2i scaleAdd(int factor, Tuple2i tuple1, Tuple2i tuple2) {
        int i = 0;
        while (i < 2) {
            this.setValue(i, factor * tuple1.values[i] + tuple2.values[i]);
            ++i;
        }
        return this;
    }

    public final Tuple2i scaleAdd(int factor, Tuple2i tuple2) {
        int i = 0;
        while (i < 2) {
            this.setValue(i, factor * this.values[i] + tuple2.values[i]);
            ++i;
        }
        return this;
    }

    public final Tuple2i clampMin(int min) {
        int i = 0;
        while (i < 2) {
            if (this.getValue(i) < min) {
                this.setValue(i, min);
            }
            ++i;
        }
        return this;
    }

    public final Tuple2i clampMax(int max) {
        int i = 0;
        while (i < 2) {
            if (this.getValue(i) > max) {
                this.setValue(i, max);
            }
            ++i;
        }
        return this;
    }

    public final Tuple2i clamp(int min, int max) {
        this.clampMin(min);
        this.clampMax(max);
        return this;
    }

    public final Tuple2i clamp(int min, int max, Tuple2i tuple) {
        this.set(tuple);
        this.clamp(min, max);
        return this;
    }

    public final Tuple2i clampMin(int min, Tuple2i tuple) {
        this.set(tuple);
        this.clampMin(min);
        return this;
    }

    public final Tuple2i clampMax(int max, Tuple2i tuple) {
        this.set(tuple);
        this.clampMax(max);
        return this;
    }

    public int hashCode() {
        return this.values[0] ^ this.values[1];
    }

    public boolean equals(Tuple2i tuple2) {
        int i = 0;
        while (i < 2) {
            if (tuple2.getValue(i) != this.getValue(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object tuple2) {
        return tuple2 != null && tuple2 instanceof Tuple2i && this.equals((Tuple2i)tuple2);
    }

    public String toString() {
        return "(" + this.getValue(0) + ", " + this.getValue(1) + ")";
    }

    public Tuple2i clone() {
        try {
            return (Tuple2i)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public int serialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < 2) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.isDirty, pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < 2) {
            this.values[i] = SerializationUtils.readIntFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.isDirty = SerializationUtils.readBoolFromBuffer(pos, buffer);
        return ++pos;
    }

    protected int getSerializationBufferSize() {
        return 9;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    protected Tuple2i(boolean readOnly, int x, int y) {
        this.values = new int[]{x, y};
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
    }

    protected Tuple2i(boolean readOnly, int[] values) {
        this(readOnly, values[0], values[1]);
    }

    protected Tuple2i(boolean readOnly, Tuple2i that) {
        this(readOnly, that.values);
    }

    protected Tuple2i(boolean readOnly) {
        this(readOnly, 0, 0);
    }

    public Tuple2i(int x, int y) {
        this(false, x, y);
    }

    public Tuple2i(int[] values) {
        this(false, values);
    }

    public Tuple2i(Tuple2i that) {
        this(false, that);
    }

    public Tuple2i() {
        this(false, 0, 0);
    }

    public static Tuple2i newReadOnly(int x, int y) {
        return new Tuple2i(true, x, y);
    }

    public static Tuple2i newReadOnly(int[] values) {
        return new Tuple2i(true, values);
    }

    public static Tuple2i newReadOnly(Tuple2i tuple) {
        return new Tuple2i(true, tuple);
    }

    public static Tuple2i newReadOnly() {
        return new Tuple2i(true);
    }

    public static Tuple2i fromPool() {
        return POOL.alloc();
    }

    public static Tuple2i fromPool(int x, int y) {
        return POOL.alloc(x, y);
    }

    public static Tuple2i fromPool(Tuple2i tuple) {
        return Tuple2i.fromPool(tuple.getX(), tuple.getY());
    }

    public static void toPool(Tuple2i o) {
        POOL.free(o);
    }
}

