/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.TupleInterface;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.pools.Tuple2fPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuple2f
extends TupleNf<Tuple2f>
implements Externalizable,
TupleInterface<Tuple2f> {
    private static final long serialVersionUID = -1375260704936534068L;
    private static final Tuple2fPool POOL = new Tuple2fPool(128);

    public final Tuple2f set(float x, float y) {
        this.setX(x);
        this.setY(y);
        return this;
    }

    public final Tuple2f setX(float x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple2f setY(float y) {
        this.setValue(1, y);
        return this;
    }

    public final float getX() {
        return this.getValue(0);
    }

    public final float getY() {
        return this.getValue(1);
    }

    public final Tuple2f addX(float v) {
        this.addValue(0, v);
        return this;
    }

    public final Tuple2f addY(float v) {
        this.addValue(1, v);
        return this;
    }

    public final Tuple2f add(float x, float y) {
        this.addValue(0, x);
        this.addValue(1, y);
        return this;
    }

    public final Tuple2f subX(float v) {
        this.subValue(0, v);
        return this;
    }

    public final Tuple2f subY(float v) {
        this.subValue(1, v);
        return this;
    }

    public final Tuple2f sub(float x, float y) {
        this.subValue(0, x);
        this.subValue(1, y);
        return this;
    }

    public final Tuple2f mulX(float v) {
        this.mulValue(0, v);
        return this;
    }

    public final Tuple2f mulY(float v) {
        this.mulValue(1, v);
        return this;
    }

    public final Tuple2f mul(float vx, float vy) {
        this.mulValue(0, vx);
        this.mulValue(1, vy);
        return this;
    }

    public final Tuple2f divX(float v) {
        this.divValue(0, v);
        return this;
    }

    public final Tuple2f divY(float v) {
        this.divValue(1, v);
        return this;
    }

    public final Tuple2f div(float vx, float vy) {
        this.divValue(0, vx);
        this.divValue(1, vy);
        return this;
    }

    public final Tuple2f scale(float factorX, float factorY) {
        this.mul(factorX, factorY);
        return this;
    }

    @Override
    public boolean equals(Object tuple2) {
        return tuple2 != null && tuple2 instanceof Tuple2f && ((TupleNf)this).equals((Tuple2f)tuple2);
    }

    public Tuple2f clone() {
        try {
            return (Tuple2f)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    protected Tuple2f(boolean readOnly, float x, float y) {
        super(readOnly, 2);
        this.values[0] = x;
        this.values[1] = y;
    }

    protected Tuple2f(boolean readOnly, float[] values) {
        super(readOnly, values, 2, true);
    }

    protected Tuple2f(boolean readOnly, Tuple2f that) {
        super(readOnly, that);
    }

    protected Tuple2f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f);
    }

    public Tuple2f(float x, float y) {
        this(false, x, y);
    }

    public Tuple2f(float[] values) {
        this(false, values);
    }

    public Tuple2f(Tuple2f that) {
        this(false, that);
    }

    public Tuple2f() {
        this(false, 0.0f, 0.0f);
    }

    public static Tuple2f newReadOnly(float x, float y) {
        return new Tuple2f(true, x, y);
    }

    public static Tuple2f newReadOnly(float[] values) {
        return new Tuple2f(true, values);
    }

    public static Tuple2f newReadOnly(Tuple2f tuple) {
        return new Tuple2f(true, tuple);
    }

    public static Tuple2f newReadOnly() {
        return new Tuple2f(true);
    }

    public static Tuple2f fromPool() {
        return POOL.alloc();
    }

    public static Tuple2f fromPool(float x, float y) {
        return POOL.alloc(x, y);
    }

    public static Tuple2f fromPool(Tuple2f tuple) {
        return Tuple2f.fromPool(tuple.getX(), tuple.getY());
    }

    public static void toPool(Tuple2f o) {
        POOL.free(o);
    }
}

