/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.pools.TexCoord1fPool;

public class TexCoord1f
extends TexCoordf
implements Externalizable {
    private static final long serialVersionUID = -8577168782997168074L;
    private static final TexCoord1fPool POOL = new TexCoord1fPool(32);

    public final TexCoord1f set(float s) {
        this.setS(s);
        return this;
    }

    public final TexCoord1f setS(float s) {
        this.values[this.roTrick + 0] = s;
        this.isDirty = true;
        return this;
    }

    public final float getS() {
        return this.values[0];
    }

    public final TexCoord1f addS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f subS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f mulS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f mul(float vs) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vs;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f divS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f div(float vs) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vs;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f add(float s) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + s;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f sub(float s) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - s;
        this.isDirty = true;
        return this;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof TexCoord1f && this.equals((TexCoord1f)o);
    }

    public TexCoord1f clone() {
        try {
            return (TexCoord1f)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public TexCoord1f(boolean readOnly, float s) {
        super(readOnly, new float[]{s});
    }

    public TexCoord1f(boolean readOnly, float[] values) {
        this(readOnly, values[0]);
    }

    public TexCoord1f(boolean readOnly, TexCoordf texCoord) {
        super(readOnly, TexCoord1f.newArray(texCoord.values, 1));
    }

    public TexCoord1f(boolean readOnly) {
        this(readOnly, 0.0f);
    }

    public TexCoord1f(float s) {
        this(false, s);
    }

    public TexCoord1f(float[] values) {
        this(false, values);
    }

    public TexCoord1f(TexCoordf texCoord) {
        this(false, texCoord);
    }

    public TexCoord1f() {
        this(false);
    }

    public static TexCoord1f fromPool() {
        return POOL.alloc();
    }

    public static TexCoord1f fromPool(float s) {
        return POOL.alloc(s);
    }

    public static void toPool(TexCoord1f o) {
        POOL.free(o);
    }
}

