/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.nio.FloatBuffer;
import org.openmali.vecmath2.Matrix3f;

class SubMatrix3f
extends Matrix3f {
    private static final long serialVersionUID = 7372605249739675868L;

    public FloatBuffer writeToBuffer(FloatBuffer buffer) {
        buffer.clear();
        buffer.put(this.m00());
        buffer.put(this.m10());
        buffer.put(this.m20());
        buffer.put(this.m01());
        buffer.put(this.m11());
        buffer.put(this.m21());
        buffer.put(this.m02());
        buffer.put(this.m12());
        buffer.put(this.m22());
        buffer.flip();
        return buffer;
    }

    public SubMatrix3f mul(float scalar) {
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                int n = this.roTrick + this.dataBegin + r * this.colSkip + c;
                this.values[n] = this.values[n] * scalar;
                ++c;
            }
            ++r;
        }
        this.isDirty = true;
        return this;
    }

    public SubMatrix3f invert() {
        float d = this.determinant();
        if (d == 0.0f) {
            return this;
        }
        d = 1.0f / d;
        this.set(this.m11() * this.m22() - this.m12() * this.m21(), this.m02() * this.m21() - this.m01() * this.m22(), this.m01() * this.m12() - this.m02() * this.m11(), this.m12() * this.m20() - this.m10() * this.m22(), this.m00() * this.m22() - this.m02() * this.m20(), this.m02() * this.m10() - this.m00() * this.m12(), this.m10() * this.m21() - this.m11() * this.m20(), this.m01() * this.m20() - this.m00() * this.m21(), this.m00() * this.m11() - this.m01() * this.m10());
        this.mul(d);
        return this;
    }

    public void interpolate(Matrix3f m1, Matrix3f m2, float alpha) {
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.set(r, c, m1.get(r, c) + (m2.get(r, c) - m1.get(r, c)) * alpha);
                ++c;
            }
            ++r;
        }
        this.isDirty = true;
    }

    public SubMatrix3f(boolean readOnly, int dataBegin, int colSkip, float[] values) {
        super(readOnly, dataBegin, colSkip, values);
    }
}

