/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMath;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.Vector4f;
import org.openmali.vecmath2.pools.Quaternion4fPool;
import org.openmali.vecmath2.util.VecMathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Quaternion4f
extends TupleNf<Quaternion4f>
implements Externalizable {
    private static final long serialVersionUID = -8111082760556105489L;
    public static final Quaternion4f ZERO = Quaternion4f.newReadOnly(0.0f, 0.0f, 0.0f, 0.0f);
    private static final Quaternion4fPool POOL = new Quaternion4fPool(128);

    public final Quaternion4f setA(float a) {
        this.setValue(0, a);
        return this;
    }

    public final Quaternion4f setB(float b) {
        this.setValue(1, b);
        return this;
    }

    public final Quaternion4f setC(float c) {
        this.setValue(2, c);
        return this;
    }

    public final Quaternion4f setD(float d) {
        this.setValue(3, d);
        return this;
    }

    public final float getA() {
        return this.getValue(0);
    }

    public final float getB() {
        return this.getValue(1);
    }

    public final float getC() {
        return this.getValue(2);
    }

    public final float getD() {
        return this.getValue(3);
    }

    public final Quaternion4f set(float a, float b, float c, float d) {
        this.setA(a);
        this.setB(b);
        this.setC(c);
        this.setD(d);
        return this;
    }

    public final Vector3f getVectorComponent(Vector3f v) {
        int i = 0;
        while (i < 3) {
            v.setValue(i, this.getValue(i));
            ++i;
        }
        return v;
    }

    public final Quaternion4f set(Matrix4f mat) {
        this.setFromMat(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public final Quaternion4f set(Matrix3f mat) {
        this.setFromMat(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public final Quaternion4f set(AxisAngle3f aa3f) {
        this.setValue(0, aa3f.getX());
        this.setValue(1, aa3f.getY());
        this.setValue(2, aa3f.getZ());
        float n = FastMath.sqrt(this.getA() * this.getA() + this.getB() * this.getB() + this.getC() * this.getC());
        float s = FastMath.sin(0.5f * aa3f.getAngle()) / n;
        this.mulValue(0, s);
        this.mulValue(1, s);
        this.mulValue(2, s);
        this.setValue(3, FastMath.cos(0.5f * aa3f.getAngle()));
        return this;
    }

    public final Quaternion4f set(Vector3f v, float w) {
        int i = 0;
        while (i < 3) {
            this.setValue(i, v.getValue(i));
            ++i;
        }
        this.setValue(3, w);
        return this;
    }

    public final Quaternion4f set(Vector4f v) {
        int i = 0;
        while (i < 4) {
            this.setValue(i, v.getValue(i));
            ++i;
        }
        return this;
    }

    public final float getNorm() {
        return this.getA() * this.getA() + this.getB() * this.getB() + this.getC() * this.getC() + this.getD() * this.getD();
    }

    public final Quaternion4f invert(Quaternion4f quat) {
        float n = quat.getNorm();
        this.setA(-quat.getA() / n);
        this.setB(-quat.getB() / n);
        this.setC(-quat.getC() / n);
        this.setD(quat.getD() / n);
        return this;
    }

    public final Quaternion4f invert() {
        return this.invert(this);
    }

    public final Quaternion4f conjugate(Quaternion4f quat) {
        this.setA(-quat.getA());
        this.setB(-quat.getB());
        this.setC(-quat.getC());
        this.setD(quat.getD());
        return this;
    }

    public final Quaternion4f conjugate() {
        this.setA(-this.getA());
        this.setB(-this.getB());
        this.setC(-this.getC());
        return this;
    }

    public final Quaternion4f normalize(Quaternion4f quat) {
        float n = FastMath.sqrt(quat.getNorm());
        this.setA(quat.getA() / n);
        this.setB(quat.getB() / n);
        this.setC(quat.getC() / n);
        this.setD(quat.getD() / n);
        return this;
    }

    public final Quaternion4f normalize() {
        return this.normalize(this);
    }

    public final Quaternion4f mul(Quaternion4f quat1, Quaternion4f quat2) {
        this.set(quat1.getA() * quat2.getD() + quat1.getD() * quat2.getA() + quat1.getB() * quat2.getC() - quat1.getC() * quat2.getB(), quat1.getB() * quat2.getD() + quat1.getD() * quat2.getB() + quat1.getC() * quat2.getA() - quat1.getA() * quat2.getC(), quat1.getC() * quat2.getD() + quat1.getD() * quat2.getC() + quat1.getA() * quat2.getB() - quat1.getB() * quat2.getA(), quat1.getD() * quat2.getD() - quat1.getA() * quat2.getA() - quat1.getB() * quat2.getB() - quat1.getC() * quat2.getC());
        return this;
    }

    public final Quaternion4f mul(Quaternion4f quat2) {
        this.set(this.getA() * quat2.getD() + this.getD() * quat2.getA() + this.getB() * quat2.getC() - this.getC() * quat2.getB(), this.getB() * quat2.getD() + this.getD() * quat2.getB() + this.getC() * quat2.getA() - this.getA() * quat2.getC(), this.getC() * quat2.getD() + this.getD() * quat2.getC() + this.getA() * quat2.getB() - this.getB() * quat2.getA(), this.getD() * quat2.getD() - this.getA() * quat2.getA() - this.getB() * quat2.getB() - this.getC() * quat2.getC());
        return this;
    }

    public final Quaternion4f mulInverse(Quaternion4f quat1, Quaternion4f quat2) {
        float n = this.getNorm();
        n = n == 0.0f ? n : 1.0f / n;
        this.set((quat1.getA() * quat2.getD() - quat1.getD() * quat2.getA() - quat1.getB() * quat2.getC() + quat1.getC() * quat2.getB()) * n, (quat1.getB() * quat2.getD() - quat1.getD() * quat2.getB() - quat1.getC() * quat2.getA() + quat1.getA() * quat2.getC()) * n, (quat1.getC() * quat2.getD() - quat1.getD() * quat2.getC() - quat1.getA() * quat2.getB() + quat1.getB() * quat2.getA()) * n, (quat1.getD() * quat2.getD() + quat1.getA() * quat2.getA() + quat1.getB() * quat2.getB() + quat1.getC() * quat2.getC()) * n);
        return this;
    }

    public final Quaternion4f mulInverse(Quaternion4f quat2) {
        float n = this.getNorm();
        n = n == 0.0f ? n : 1.0f / n;
        this.set((this.getA() * quat2.getD() - this.getD() * quat2.getA() - this.getB() * quat2.getC() + this.getC() * quat2.getB()) * n, (this.getB() * quat2.getD() - this.getD() * quat2.getB() - this.getC() * quat2.getA() + this.getA() * quat2.getC()) * n, (this.getC() * quat2.getD() - this.getD() * quat2.getC() - this.getA() * quat2.getB() + this.getB() * quat2.getA()) * n, (this.getD() * quat2.getD() + this.getA() * quat2.getA() + this.getB() * quat2.getB() + this.getC() * quat2.getC()) * n);
        return this;
    }

    public final Quaternion4f setMulScale(float scale, Vector3f v, Quaternion4f q) {
        this.set(v, 0.0f);
        this.mul(q);
        this.scale(scale);
        return this;
    }

    public final Quaternion4f setDQDT(Vector3f angularVelocity, Quaternion4f passback) {
        this.setMulScale(0.5f, angularVelocity, passback);
        return this;
    }

    @Override
    public void interpolate(Quaternion4f quat2, float alpha) {
        this.normalize();
        float n2 = FastMath.sqrt(quat2.getNorm());
        float a2 = quat2.getA() / n2;
        float b2 = quat2.getB() / n2;
        float c2 = quat2.getC() / n2;
        float d2 = quat2.getD() / n2;
        float t = this.getA() * a2 + this.getB() * b2 + this.getC() * c2 + this.getD() * d2;
        if (1.0f <= Math.abs(t)) {
            return;
        }
        float sin_t = FastMath.sin(t = FastMath.acos(t));
        if (sin_t == 0.0f) {
            return;
        }
        float s = FastMath.sin((1.0f - alpha) * t) / sin_t;
        t = FastMath.sin(alpha * t) / sin_t;
        this.setA(s * this.getA() + t * a2);
        this.setB(s * this.getB() + t * b2);
        this.setC(s * this.getC() + t * c2);
        this.setD(s * this.getD() + t * d2);
    }

    public static float interpolateSLERP(Quaternion4f q1, Quaternion4f q2, float amount, Quaternion4f result) {
        float dotProduct = VecMathUtils.dot(q1, q2);
        if (FastMath.epsilonEquals(dotProduct, 1.0f, 1.0E-5f) || FastMath.epsilonEquals(dotProduct, -1.0f, 1.0E-5f)) {
            result.set((TupleNf)q1);
            return 0.0f;
        }
        if (amount == 0.0f) {
            result.set((TupleNf)q1);
            return 0.0f;
        }
        if (dotProduct < 0.0f) {
            dotProduct = -dotProduct;
            q1.scale(-1.0f);
        }
        if (amount == 1.0f) {
            result.set((TupleNf)q2);
            return FastMath.acos(dotProduct);
        }
        float omega = FastMath.acos(dotProduct);
        float sinOmega = FastMath.sin(omega);
        float sinTOmega = FastMath.sin(omega * amount);
        float sin1minusTOmega = FastMath.sin(omega * (1.0f - amount));
        Vector4f tmp = Vector4f.fromPool();
        tmp.set((TupleNf)q1);
        tmp.scale(sin1minusTOmega / sinOmega);
        result.set((TupleNf)q2);
        result.scale(sinTOmega / sinOmega);
        result.addValue(0, tmp.getX());
        result.addValue(1, tmp.getY());
        result.addValue(2, tmp.getZ());
        result.addValue(3, tmp.getW());
        Vector4f.toPool(tmp);
        assert ((double)omega < Math.PI && (double)omega > -Math.PI);
        return omega;
    }

    public float interpolateSLERP(Quaternion4f q1, Quaternion4f q2, float amount) {
        return Quaternion4f.interpolateSLERP(q1, q2, amount, this);
    }

    public static Quaternion4f weightedSLERP(Quaternion4f start, Quaternion4f target, Vector3f rotationAxis1, Vector3f rotationAxis2, Vector3f rotationAxis3, Vector3f weights, Vector3f anglePassback, Quaternion4f result) {
        Quaternion4f start_copy = Quaternion4f.fromPool();
        start_copy.set((TupleNf)start);
        float dotProduct = VecMathUtils.dot(start_copy, target);
        if (FastMath.epsilonEquals(dotProduct, 1.0f, 1.0E-5f) || FastMath.epsilonEquals(dotProduct, -1.0f, 1.0E-5f)) {
            if (anglePassback != null) {
                anglePassback.setZero();
            }
            result.set((TupleNf)target);
            return result;
        }
        if (dotProduct < 0.0f) {
            dotProduct = -dotProduct;
            start_copy.scale(-1.0f);
        }
        assert (FastMath.epsilonEquals(rotationAxis1.lengthSquared(), 1.0f, 1.0E-4f));
        assert (FastMath.epsilonEquals(rotationAxis2.lengthSquared(), 1.0f, 1.0E-4f));
        assert (FastMath.epsilonEquals(rotationAxis3.lengthSquared(), 1.0f, 1.0E-4f));
        Quaternion4f n1 = Quaternion4f.fromPool();
        Quaternion4f n2 = Quaternion4f.fromPool();
        Quaternion4f n3 = Quaternion4f.fromPool();
        start_copy.getDirection(rotationAxis1, n1);
        start_copy.getDirection(rotationAxis2, n2);
        start_copy.getDirection(rotationAxis3, n3);
        assert (FastMath.epsilonEquals(n1.getNorm(), 1.0f, 1.0E-4f));
        assert (FastMath.epsilonEquals(n2.getNorm(), 1.0f, 1.0E-4f));
        assert (FastMath.epsilonEquals(n3.getNorm(), 1.0f, 1.0E-4f));
        Quaternion4f c1 = Quaternion4f.fromPool();
        Quaternion4f c2 = Quaternion4f.fromPool();
        Quaternion4f c3 = Quaternion4f.fromPool();
        Vector4f.getLinearHyperPlaneNormal(n2, n3, target, c1);
        Vector4f.getLinearHyperPlaneNormal(n1, n3, target, c2);
        Vector4f.getLinearHyperPlaneNormal(n1, n2, target, c3);
        assert (FastMath.epsilonEquals(c1.getNorm(), 1.0f, 1.0E-4f));
        assert (FastMath.epsilonEquals(c2.getNorm(), 1.0f, 1.0E-4f));
        assert (FastMath.epsilonEquals(c3.getNorm(), 1.0f, 1.0E-4f));
        Quaternion4f r1 = Quaternion4f.fromPool();
        Quaternion4f r2 = Quaternion4f.fromPool();
        Quaternion4f r3 = Quaternion4f.fromPool();
        if (anglePassback != null) {
            anglePassback.setX(Quaternion4f.interpolateSLERP(n1, c1, weights.getX(), r1) / 2.0f);
            anglePassback.setY(Quaternion4f.interpolateSLERP(n2, c2, weights.getY(), r2) / 2.0f);
            anglePassback.setZ(Quaternion4f.interpolateSLERP(n3, c3, weights.getZ(), r3) / 2.0f);
            Quaternion4f.toPool(c3);
            Quaternion4f.toPool(c2);
            Quaternion4f.toPool(c1);
            Quaternion4f.toPool(n3);
            Quaternion4f.toPool(n2);
            Quaternion4f.toPool(n1);
            Quaternion4f tmp = Quaternion4f.fromPool();
            tmp.set((TupleNf)target);
            tmp.sub(start_copy);
            Quaternion4f tx = Quaternion4f.fromPool();
            Quaternion4f ty = Quaternion4f.fromPool();
            Quaternion4f tz = Quaternion4f.fromPool();
            tx.setDQDT(rotationAxis1, start_copy);
            ty.setDQDT(rotationAxis2, start_copy);
            tz.setDQDT(rotationAxis3, start_copy);
            if (VecMathUtils.dot(tx, tmp) < 0.0f) {
                anglePassback.setX(-anglePassback.getX());
            }
            if (VecMathUtils.dot(ty, tmp) < 0.0f) {
                anglePassback.setY(-anglePassback.getY());
            }
            if (VecMathUtils.dot(tz, tmp) < 0.0f) {
                anglePassback.setZ(-anglePassback.getZ());
            }
        } else {
            Quaternion4f.interpolateSLERP(n1, c1, weights.getX(), r1);
            Quaternion4f.interpolateSLERP(n2, c2, weights.getY(), r2);
            Quaternion4f.interpolateSLERP(n3, c3, weights.getZ(), r3);
            Quaternion4f.toPool(c3);
            Quaternion4f.toPool(c2);
            Quaternion4f.toPool(c1);
            Quaternion4f.toPool(n3);
            Quaternion4f.toPool(n2);
            Quaternion4f.toPool(n1);
        }
        Vector4f.getLinearHyperPlaneNormal(r1, r2, r3, result);
        assert (FastMath.epsilonEquals(VecMathUtils.dot(result, r1), 0.0f, 1.0E-4f));
        assert (FastMath.epsilonEquals(VecMathUtils.dot(result, r2), 0.0f, 1.0E-4f));
        assert (FastMath.epsilonEquals(VecMathUtils.dot(result, r3), 0.0f, 1.0E-4f));
        Quaternion4f.toPool(r3);
        Quaternion4f.toPool(r2);
        Quaternion4f.toPool(r1);
        result.normalize();
        return result;
    }

    public final void getDirection(Vector3f rotationAxis, TupleNf<?> passbackNormal) {
        Vector3f tmpV = Vector3f.fromPool();
        Vector3f tmpVa = Vector3f.fromPool();
        this.getVectorComponent(tmpV);
        passbackNormal.setValue(3, -tmpV.dot(rotationAxis));
        tmpVa.cross(tmpV, rotationAxis);
        int i = 0;
        while (i < 3) {
            passbackNormal.setValue(i, tmpVa.getValue(i) + this.getD() * rotationAxis.getValue(i));
            ++i;
        }
        VecMathUtils.normalize(passbackNormal);
        Vector3f.toPool(tmpV);
        Vector3f.toPool(tmpVa);
    }

    public static void getAngles(Quaternion4f q1, Quaternion4f q2, Vector3f rotationAxis1, Vector3f rotationAxis2, Vector3f rotationAxis3, Vector3f passback) {
        float angle3;
        Vector4f d1 = Vector4f.fromPool();
        Vector4f d2 = Vector4f.fromPool();
        Vector4f d3 = Vector4f.fromPool();
        Quaternion4f target = Quaternion4f.fromPool();
        target.set((TupleNf)q2);
        if (VecMathUtils.dot(q1, q2) < 0.0f) {
            target.scale(-1.0f);
        }
        q1.getDirection(rotationAxis1, d1);
        q1.getDirection(rotationAxis2, d2);
        q1.getDirection(rotationAxis3, d3);
        float distCommon = VecMathUtils.dot(target, q1);
        Vector3f common = Vector3f.fromPool();
        q1.getVectorComponent(common);
        common.scale(distCommon);
        Vector3f targetVec = Vector3f.fromPool();
        target.getVectorComponent(targetVec);
        float dist1 = VecMathUtils.dot(targetVec, d1);
        float dist2 = VecMathUtils.dot(targetVec, d2);
        float dist3 = VecMathUtils.dot(targetVec, d3);
        Vector3f.toPool(targetVec);
        d1.scale(dist1);
        d2.scale(dist2);
        d3.scale(dist3);
        d1.add(common.getX(), common.getY(), common.getZ(), 0.0f);
        d2.add(common.getX(), common.getY(), common.getZ(), 0.0f);
        d3.add(common.getX(), common.getY(), common.getZ(), 0.0f);
        d1.normalize();
        d2.normalize();
        d3.normalize();
        float angle1 = VecMathUtils.epsilonEquals(q1, d1, 1.0E-5f) ? 0.0f : FastMath.acos(VecMathUtils.dot(q1, d1));
        float angle2 = VecMathUtils.epsilonEquals(q1, d2, 1.0E-5f) ? 0.0f : FastMath.acos(VecMathUtils.dot(q1, d2));
        float f = angle3 = VecMathUtils.epsilonEquals(q1, d3, 1.0E-5f) ? 0.0f : FastMath.acos(VecMathUtils.dot(q1, d3));
        if (Float.isNaN(angle1)) {
            angle1 = 0.0f;
        } else if (dist1 < 0.0f) {
            angle1 = -angle1;
        }
        if (Float.isNaN(angle2)) {
            angle2 = 0.0f;
        } else if (dist2 < 0.0f) {
            angle2 = -angle2;
        }
        if (Float.isNaN(angle3)) {
            angle3 = 0.0f;
        } else if (dist3 < 0.0f) {
            angle3 = -angle3;
        }
        passback.set(angle1 / 2.0f, angle2 / 2.0f, angle3 / 2.0f);
        Quaternion4f.toPool(target);
        Vector3f.toPool(common);
        Vector4f.toPool(d1);
        Vector4f.toPool(d2);
        Vector4f.toPool(d3);
    }

    private final void setFromMat(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float tr = m00 + m11 + m22;
        if (tr >= 0.0f) {
            float s = FastMath.sqrt(tr + 1.0f);
            this.setD(s * 0.5f);
            s = 0.5f / s;
            this.setA((m21 - m12) * s);
            this.setB((m02 - m20) * s);
            this.setC((m10 - m01) * s);
        } else {
            float max = Math.max(Math.max(m00, m11), m22);
            if (max == m00) {
                float s = FastMath.sqrt(m00 - (m11 + m22) + 1.0f);
                this.setA(s * 0.5f);
                s = 0.5f / s;
                this.setB((m01 + m10) * s);
                this.setC((m20 + m02) * s);
                this.setD((m21 - m12) * s);
            } else if (max == m11) {
                float s = FastMath.sqrt(m11 - (m22 + m00) + 1.0f);
                this.setB(s * 0.5f);
                s = 0.5f / s;
                this.setC((m12 + m21) * s);
                this.setA((m01 + m10) * s);
                this.setD((m02 - m20) * s);
            } else {
                float s = FastMath.sqrt(m22 - (m00 + m11) + 1.0f);
                this.setC(s * 0.5f);
                s = 0.5f / s;
                this.setA((m20 + m02) * s);
                this.setB((m12 + m21) * s);
                this.setD((m10 - m01) * s);
            }
        }
    }

    @Override
    public final boolean equals(Object o) {
        return o != null && o instanceof Quaternion4f && ((TupleNf)this).equals((Quaternion4f)o);
    }

    public Quaternion4f clone() {
        try {
            return (Quaternion4f)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    protected Quaternion4f(boolean readOnly, float a, float b, float c, float d) {
        super(readOnly, 4);
        this.values[0] = a;
        this.values[1] = b;
        this.values[2] = c;
        this.values[3] = d;
    }

    protected Quaternion4f(boolean readOnly, float[] values) {
        super(readOnly, values, 4, true);
    }

    protected Quaternion4f(boolean readOnly, Quaternion4f quat) {
        super(readOnly, quat);
    }

    protected Quaternion4f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Quaternion4f(float a, float b, float c, float d) {
        this(false, a, b, c, d);
    }

    public Quaternion4f(float[] values) {
        this(false, values);
    }

    public Quaternion4f(Quaternion4f quat) {
        this(false, quat);
    }

    public Quaternion4f() {
        this(false);
    }

    public static Quaternion4f newReadOnly(float a, float b, float c, float d) {
        return new Quaternion4f(true, a, b, c, d);
    }

    public static Quaternion4f newReadOnly(float[] values) {
        return new Quaternion4f(true, values);
    }

    public static Quaternion4f newReadOnly(Quaternion4f quat) {
        return new Quaternion4f(true, quat);
    }

    public static Quaternion4f newReadOnly() {
        return new Quaternion4f(true);
    }

    public static Quaternion4f fromPool() {
        return POOL.alloc();
    }

    public static Quaternion4f fromPool(float a, float b, float c, float d) {
        return POOL.alloc(a, b, c, d);
    }

    public static Quaternion4f fromPool(Quaternion4f quat) {
        return Quaternion4f.fromPool(quat.getA(), quat.getB(), quat.getC(), quat.getD());
    }

    public static void toPool(Quaternion4f o) {
        POOL.free(o);
    }
}

