/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMath;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.pools.Coord3fPool;

public class Coord3f
extends Vector3f
implements Externalizable {
    private static final long serialVersionUID = -3150413100999613785L;
    public static final Coord3f ZERO = Coord3f.newReadOnly(0.0f, 0.0f, 0.0f);
    private static final Coord3fPool POOL = new Coord3fPool(128);

    public final void set(Coord3f coord) {
        this.set(coord.getX(), coord.getY(), coord.getZ());
    }

    public final void get(Coord3f buffer) {
        buffer.setX(this.getX());
        buffer.setY(this.getY());
        buffer.setZ(this.getZ());
    }

    public final float distanceSquared(Tuple3f a, Tuple3f b) {
        float dx = a.getX() - b.getX();
        float dy = a.getY() - b.getY();
        float dz = a.getZ() - b.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public final float distanceSquared(Tuple3f a) {
        float dx = this.getX() - a.getX();
        float dy = this.getY() - a.getY();
        float dz = this.getZ() - a.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public final float distance(Tuple3f a) {
        return FastMath.sqrt(this.distanceSquared(a));
    }

    public final float distance(Tuple3f a, Tuple3f b) {
        return FastMath.sqrt(this.distanceSquared(a, b));
    }

    public final void normalize(Tuple3f vector) {
        this.set((TupleNf)vector);
        this.normalize();
    }

    public final void cross(Tuple3f v1, Tuple3f v2) {
        this.set(v1.getY() * v2.getZ() - v1.getZ() * v2.getY(), v1.getZ() * v2.getX() - v1.getX() * v2.getZ(), v1.getX() * v2.getY() - v1.getY() * v2.getX());
    }

    public final float dot(Tuple3f v2) {
        return this.getX() * v2.getX() + this.getY() * v2.getY() + this.getZ() * v2.getZ();
    }

    public final float angle(Tuple3f v2) {
        float xx = this.getX() * v2.getZ() - this.getZ() * v2.getY();
        float yy = this.getZ() * v2.getX() - this.getX() * v2.getZ();
        float zz = this.getX() * v2.getY() - this.getY() * v2.getX();
        float cross = FastMath.sqrt(xx * xx + yy * yy + zz * zz);
        return Math.abs(FastMath.atan2(cross, this.dot(v2)));
    }

    public static final Coord3f subNew(Coord3f c1, Coord3f c2) {
        Coord3f c = Coord3f.fromPool();
        c.sub(c1, c2);
        return c;
    }

    public static final Coord3f crossNew(Coord3f c1, Coord3f c2) {
        Coord3f c = Coord3f.fromPool();
        c.cross(c1, c2);
        return c;
    }

    public static final Coord3f scaleNew(Coord3f c1, float scale) {
        Coord3f c = Coord3f.fromPool();
        c.set((TupleNf)c1);
        c.scale(scale);
        return c;
    }

    protected Coord3f(boolean readOnly, float x, float y, float z) {
        super(readOnly, x, y, z);
    }

    protected Coord3f(boolean readOnly, float[] values) {
        this(readOnly, values[0], values[1], values[2]);
    }

    protected Coord3f(boolean readOnly, Tuple3f tuple) {
        this(readOnly, tuple.getX(), tuple.getY(), tuple.getZ());
    }

    protected Coord3f(boolean readOnly) {
        super(readOnly, 0.0f, 0.0f, 0.0f);
    }

    public Coord3f(float x, float y, float z) {
        this(false, x, y, z);
    }

    public Coord3f(float[] values) {
        this(false, values);
    }

    public Coord3f(Tuple3f tuple) {
        this(false, tuple);
    }

    public Coord3f() {
        this(false);
    }

    public static Coord3f newReadOnly(float x, float y, float z) {
        return new Coord3f(true, x, y, z);
    }

    public static Coord3f newReadOnly(float[] values) {
        return new Coord3f(true, values);
    }

    public static Coord3f newReadOnly(Tuple3f tuple) {
        return new Coord3f(true, tuple);
    }

    public static Coord3f newReadOnly() {
        return new Coord3f(true);
    }

    public static Coord3f fromPool() {
        return POOL.alloc();
    }

    public static Coord3f fromPool(float x, float y, float z) {
        return POOL.alloc(x, y, z);
    }

    public static Coord3f fromPool(Tuple3f tuple) {
        return Coord3f.fromPool(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public static void toPool(Coord3f o) {
        POOL.free(o);
    }

    public static /* bridge */ /* synthetic */ Vector3f newReadOnly() {
        return Coord3f.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Vector3f newReadOnly(Tuple3f tuple3f) {
        return Coord3f.newReadOnly(tuple3f);
    }

    public static /* bridge */ /* synthetic */ Vector3f newReadOnly(float[] fArray) {
        return Coord3f.newReadOnly(fArray);
    }

    public static /* bridge */ /* synthetic */ Vector3f newReadOnly(float f, float f2, float f3) {
        return Coord3f.newReadOnly(f, f2, f3);
    }

    public static /* bridge */ /* synthetic */ Vector3f fromPool(Tuple3f tuple3f) {
        return Coord3f.fromPool(tuple3f);
    }

    public static /* bridge */ /* synthetic */ Vector3f fromPool(float f, float f2, float f3) {
        return Coord3f.fromPool(f, f2, f3);
    }

    public static /* bridge */ /* synthetic */ Vector3f fromPool() {
        return Coord3f.fromPool();
    }
}

