/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.FloatBuffer;
import org.openmali.vecmath2.pools.ColorPool;
import org.openmali.vecmath2.util.ColorUtil;
import org.openmali.vecmath2.util.SerializationUtils;

public class Colorf
implements Externalizable {
    private static final long serialVersionUID = -818575512943622856L;
    private static final ColorPool POOL = new ColorPool(32);
    protected static final int N = 4;
    protected final float[] values;
    protected boolean hasAlpha;
    protected final int roTrick;
    protected boolean isDirty = false;
    public static final Colorf WHITE = new Colorf(true, Color.WHITE);
    public static final Colorf LIGHT_GRAY = new Colorf(true, Color.GRAY);
    public static final Colorf GRAY10 = new Colorf(true, 0.9f);
    public static final Colorf GRAY20 = new Colorf(true, 0.8f);
    public static final Colorf GRAY25 = new Colorf(true, 0.75f);
    public static final Colorf GRAY30 = new Colorf(true, 0.7f);
    public static final Colorf GRAY40 = new Colorf(true, 0.6f);
    public static final Colorf GRAY50 = new Colorf(true, 0.5f);
    public static final Colorf GRAY60 = new Colorf(true, 0.4f);
    public static final Colorf GRAY70 = new Colorf(true, 0.3f);
    public static final Colorf GRAY75 = new Colorf(true, 0.25f);
    public static final Colorf GRAY80 = new Colorf(true, 0.2f);
    public static final Colorf GRAY90 = new Colorf(true, 0.1f);
    public static final Colorf GRAY = new Colorf(true, Color.GRAY);
    public static final Colorf DARK_GRAY = new Colorf(true, Color.DARK_GRAY);
    public static final Colorf BLACK = new Colorf(true, Color.BLACK);
    public static final Colorf BROWN = Colorf.parseReadOnlyColor("#6D493B");
    public static final Colorf LIGHT_BROWN = Colorf.parseReadOnlyColor("#91624F");
    public static final Colorf DARK_BROWN = Colorf.parseReadOnlyColor("#583B30");
    public static final Colorf RED = new Colorf(true, Color.RED);
    public static final Colorf PINK = new Colorf(true, Color.PINK);
    public static final Colorf ORANGE = new Colorf(true, Color.ORANGE);
    public static final Colorf YELLOW = new Colorf(true, Color.YELLOW);
    public static final Colorf GREEN = new Colorf(true, Color.GREEN);
    public static final Colorf MAGENTA = new Colorf(true, Color.MAGENTA);
    public static final Colorf CYAN = new Colorf(true, Color.CYAN);
    public static final Colorf BLUE = new Colorf(true, Color.BLUE);

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        boolean oldValue = this.isDirty;
        this.isDirty = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public static Colorf createGray(float intensity) {
        return new Colorf(intensity, intensity, intensity);
    }

    public final int getSize() {
        return 4;
    }

    public final boolean hasAlpha() {
        return this.hasAlpha;
    }

    public final void set(Color color) {
        this.setRed((float)color.getRed() / 255.0f);
        this.setGreen((float)color.getGreen() / 255.0f);
        this.setBlue((float)color.getBlue() / 255.0f);
        boolean bl = this.hasAlpha = color.getAlpha() < 255;
        if (this.hasAlpha) {
            this.setAlpha((float)(255 - color.getAlpha()) / 255.0f);
        }
        this.isDirty = true;
    }

    public final void set(float[] values) {
        if (values.length > 3) {
            System.arraycopy(values, 0, this.values, this.roTrick + 0, 4);
            this.hasAlpha = values[3] > 0.0f;
        } else {
            System.arraycopy(values, 0, this.values, this.roTrick + 0, 3);
            this.hasAlpha = false;
        }
        this.isDirty = true;
    }

    public final void setBytes(byte[] values) {
        if (values.length > 3) {
            this.setRedByte(values[0]);
            this.setGreenByte(values[1]);
            this.setBlueByte(values[2]);
            this.setAlphaByte(values[3]);
        } else {
            this.setRedByte(values[0]);
            this.setGreenByte(values[1]);
            this.setBlueByte(values[2]);
            this.hasAlpha = false;
        }
        this.isDirty = true;
    }

    public final void setInts(int[] values) {
        if (values.length > 3) {
            this.setRedInt(values[0]);
            this.setGreenInt(values[1]);
            this.setBlueInt(values[2]);
            this.setAlphaInt(values[3]);
        } else {
            this.setRedInt(values[0]);
            this.setGreenInt(values[1]);
            this.setBlueInt(values[2]);
            this.hasAlpha = false;
        }
        this.isDirty = true;
    }

    public final void set(Colorf color) {
        System.arraycopy(color.values, 0, this.values, this.roTrick + 0, 4);
        this.hasAlpha = color.hasAlpha;
        this.isDirty = true;
    }

    public final void set(float r, float g, float b, float a) {
        this.setRed(r);
        this.setGreen(g);
        this.setBlue(b);
        this.setAlpha(a);
        this.hasAlpha = a >= 0.0f;
        this.isDirty = true;
    }

    public final void set(float r, float g, float b) {
        this.setRed(r);
        this.setGreen(g);
        this.setBlue(b);
        this.hasAlpha = false;
        this.isDirty = true;
    }

    public final Color getAWTColor() {
        if (this.hasAlpha()) {
            return new Color(this.getRed(), this.getGreen(), this.getBlue(), 1.0f - this.getAlpha());
        }
        return new Color(this.getRed(), this.getGreen(), this.getBlue());
    }

    public final void get(float[] buffer) {
        int n = this.hasAlpha() ? 4 : 3;
        System.arraycopy(this.values, 0, buffer, 0, n);
    }

    public final void getBytes(byte[] buffer) {
        buffer[0] = this.getRedByte();
        buffer[1] = this.getGreenByte();
        buffer[2] = this.getBlueByte();
        if (this.hasAlpha() && buffer.length >= 4) {
            buffer[3] = this.getAlphaByte();
        }
    }

    public final void getInts(int[] buffer) {
        buffer[0] = this.getRedInt();
        buffer[1] = this.getGreenInt();
        buffer[2] = this.getBlueInt();
        if (this.hasAlpha() && buffer.length >= 4) {
            buffer[3] = this.getAlphaInt();
        }
    }

    public final void get(Colorf buffer) {
        System.arraycopy(this.values, 0, buffer.values, 0, 4);
        buffer.hasAlpha = this.hasAlpha;
    }

    public final FloatBuffer writeToBuffer(FloatBuffer buffer, boolean forceAlpha) {
        buffer.clear();
        if (this.hasAlpha()) {
            buffer.put(this.values);
        } else if (forceAlpha) {
            buffer.put(this.values[0]).put(this.values[1]).put(this.values[2]).put(0.0f);
        } else {
            buffer.put(this.values[0]).put(this.values[1]).put(this.values[2]);
        }
        buffer.flip();
        return buffer;
    }

    public final FloatBuffer writeToBuffer(FloatBuffer buffer) {
        return this.writeToBuffer(buffer, false);
    }

    public static final FloatBuffer writeToBuffer(Colorf[] colors, FloatBuffer buffer, boolean forceAlpha) {
        buffer.clear();
        int i = 0;
        while (i < colors.length) {
            Colorf color = colors[i];
            if (color.hasAlpha()) {
                buffer.put(color.values);
            } else if (forceAlpha) {
                buffer.put(color.values[0]).put(color.values[1]).put(color.values[2]).put(0.0f);
            } else {
                buffer.put(color.values[0]).put(color.values[1]).put(color.values[2]);
            }
            ++i;
        }
        buffer.flip();
        return buffer;
    }

    public static final FloatBuffer writeToBuffer(Colorf[] colors, FloatBuffer buffer) {
        return Colorf.writeToBuffer(colors, buffer, false);
    }

    public final void setRed(float red) {
        this.values[this.roTrick + 0] = red;
        this.isDirty = true;
    }

    public final float getRed() {
        return this.values[0];
    }

    public final void setRedByte(byte red) {
        this.values[this.roTrick + 0] = (float)(red & 0xFF) / 255.0f;
        this.isDirty = true;
    }

    public final byte getRedByte() {
        return (byte)(this.values[0] * 255.0f);
    }

    public final void setRedInt(int red) {
        this.values[this.roTrick + 0] = (float)red / 255.0f;
        this.isDirty = true;
    }

    public final int getRedInt() {
        return (int)(this.values[0] * 255.0f);
    }

    public final void setGreen(float green) {
        this.values[this.roTrick + 1] = green;
        this.isDirty = true;
    }

    public final float getGreen() {
        return this.values[1];
    }

    public final void setGreenByte(byte green) {
        this.values[this.roTrick + 1] = (float)(green & 0xFF) / 255.0f;
        this.isDirty = true;
    }

    public final byte getGreenByte() {
        return (byte)(this.values[1] * 255.0f);
    }

    public final void setGreenInt(int green) {
        this.values[this.roTrick + 1] = (float)green / 255.0f;
        this.isDirty = true;
    }

    public final int getGreenInt() {
        return (int)(this.values[1] * 255.0f);
    }

    public final void setBlue(float blue) {
        this.values[this.roTrick + 2] = blue;
        this.isDirty = true;
    }

    public final float getBlue() {
        return this.values[2];
    }

    public final void setBlueByte(byte blue) {
        this.values[this.roTrick + 2] = (float)(blue & 0xFF) / 255.0f;
        this.isDirty = true;
    }

    public final byte getBlueByte() {
        return (byte)(this.values[2] * 255.0f);
    }

    public final void setBlueInt(int blue) {
        this.values[this.roTrick + 2] = (float)blue / 255.0f;
        this.isDirty = true;
    }

    public final int getBlueInt() {
        return (int)(this.values[2] * 255.0f);
    }

    public final void setAlpha(float alpha) {
        this.values[this.roTrick + 3] = alpha;
        this.hasAlpha = alpha >= 0.0f;
        this.isDirty = true;
    }

    public final float getAlpha() {
        if (this.hasAlpha()) {
            return this.values[3];
        }
        return 0.0f;
    }

    public final void setAlphaByte(byte alpha) {
        this.values[this.roTrick + 3] = (float)(alpha & 0xFF) / 255.0f;
        this.hasAlpha = this.values[this.roTrick + 3] >= 0.0f;
        this.isDirty = true;
    }

    public final byte getAlphaByte() {
        if (this.hasAlpha()) {
            return (byte)(this.values[3] * 255.0f);
        }
        return 0;
    }

    public final void setAlphaInt(int alpha) {
        this.values[this.roTrick + 3] = (float)alpha / 255.0f;
        this.hasAlpha = this.values[this.roTrick + 3] >= 0.0f;
        this.isDirty = true;
    }

    public final int getAlphaInt() {
        if (this.hasAlpha()) {
            return (int)(this.values[3] * 255.0f);
        }
        return 0;
    }

    public final Colorf setZero() {
        int i = 0;
        while (i < 3) {
            this.values[this.roTrick + i] = 0.0f;
            ++i;
        }
        if (this.hasAlpha()) {
            this.values[this.roTrick + 3] = 0.0f;
        }
        this.isDirty = true;
        return this;
    }

    public final Colorf addRed(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Colorf addGreen(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Colorf addBlue(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Colorf addAlpha(float v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Colorf subRed(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Colorf subGreen(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Colorf subBlue(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Colorf subAlpha(float v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Colorf mulRed(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Colorf mulGreen(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Colorf mulBlue(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Colorf mulAlpha(float v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Colorf mul(float vr, float vg, float vb, float va) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vb;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] * va;
        this.isDirty = true;
        return this;
    }

    public final Colorf mul(float vr, float vg, float vb) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vb;
        this.isDirty = true;
        return this;
    }

    public final Colorf mul(float factor) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            int n2 = this.roTrick + i;
            this.values[n2] = this.values[n2] * factor;
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Colorf divRed(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Colorf divGreen(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Colorf divBlue(float v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Colorf divAlpha(float v) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Colorf div(float vr, float vg, float vb, float va) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vb;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] / va;
        this.isDirty = true;
        return this;
    }

    public final Colorf div(float vr, float vg, float vb) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vr;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vg;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vb;
        this.isDirty = true;
        return this;
    }

    public final Colorf add(Colorf color1, Colorf color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = color1.values[i] + color2.values[i];
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Colorf add(Colorf color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            int n2 = this.roTrick + i;
            this.values[n2] = this.values[n2] + color2.values[i];
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Colorf add(float r, float g, float b, float a) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + b;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] + a;
        this.isDirty = true;
        return this;
    }

    public final Colorf add(float r, float g, float b) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + b;
        this.isDirty = true;
        return this;
    }

    public final Colorf sub(Colorf color1, Colorf color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = color1.values[i] - color2.values[i];
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Colorf sub(Colorf color2) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            int n2 = this.roTrick + i;
            this.values[n2] = this.values[n2] - color2.values[i];
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Colorf sub(float r, float g, float b, float a) {
        if (!this.hasAlpha()) {
            throw new UnsupportedOperationException("no alpha channel");
        }
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - b;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] - a;
        this.isDirty = true;
        return this;
    }

    public final Colorf sub(float r, float g, float b) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - r;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - g;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - b;
        this.isDirty = true;
        return this;
    }

    public final Colorf clampMin(float min) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (this.values[i] < min) {
                this.values[this.roTrick + i] = min;
            }
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Colorf clampMax(float max) {
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (this.values[i] > max) {
                this.values[this.roTrick + i] = max;
            }
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Colorf clamp(float min, float max) {
        this.clampMin(min);
        this.clampMax(max);
        this.isDirty = true;
        return this;
    }

    public final Colorf clamp(float min, float max, Colorf vec) {
        this.set(vec);
        this.clamp(min, max);
        this.isDirty = true;
        return this;
    }

    public final Colorf clampMin(float min, Colorf vec) {
        this.set(vec);
        this.clampMin(min);
        this.isDirty = true;
        return this;
    }

    public final Colorf clampMax(float max, Colorf vec) {
        this.set(vec);
        this.clampMax(max);
        this.isDirty = true;
        return this;
    }

    public final Colorf interpolate(Colorf color2, float val) {
        float beta = 1.0f - val;
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = beta * this.values[i] + val * color2.values[i];
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Colorf interpolate(Colorf color1, Colorf color2, float val) {
        float beta = 1.0f - val;
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            this.values[this.roTrick + i] = beta * color1.values[i] + val * color2.values[i];
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    private static int floatToIntBits(float f) {
        return f == 0.0f ? 0 : Float.floatToIntBits(f);
    }

    public int hashCode() {
        int rbits = Colorf.floatToIntBits(this.values[0]);
        int gbits = Colorf.floatToIntBits(this.values[1]);
        int bbits = Colorf.floatToIntBits(this.values[2]);
        if (this.hasAlpha()) {
            return rbits ^ gbits ^ bbits ^ Colorf.floatToIntBits(this.values[3]);
        }
        return rbits ^ gbits ^ bbits;
    }

    public boolean equals(Colorf color2) {
        if (this.hasAlpha() != color2.hasAlpha()) {
            return false;
        }
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (color2.values[i] != this.values[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Colorf && this.equals((Colorf)o);
    }

    public boolean epsilonEquals(Colorf color2, float epsilon) {
        if (this.hasAlpha() != color2.hasAlpha()) {
            return false;
        }
        int n = this.hasAlpha() ? 4 : 3;
        int i = 0;
        while (i < n) {
            if (Math.abs(color2.values[i] - this.values[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final String toHexString() {
        return ColorUtil.colorToHex(this);
    }

    public String toString() {
        String str = "Color ( red = " + this.getRed() + ", green = " + this.getGreen() + ", blue = " + this.getBlue();
        if (this.hasAlpha()) {
            return String.valueOf(str) + ", alpha = " + this.getAlpha() + " )";
        }
        return String.valueOf(str) + " )";
    }

    public Colorf clone() {
        try {
            return (Colorf)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public int serialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.values.length) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.hasAlpha, pos, buffer);
        SerializationUtils.writeToBuffer(this.isDirty, ++pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = SerializationUtils.readFloatFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.hasAlpha = SerializationUtils.readBoolFromBuffer(pos, buffer);
        this.isDirty = SerializationUtils.readBoolFromBuffer(++pos, buffer);
        return ++pos;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[18];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[18];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    public Colorf(boolean readOnly, float r, float g, float b, float a) {
        this.values = new float[]{r, g, b, a};
        this.hasAlpha = a >= 0.0f;
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
    }

    public Colorf(boolean readOnly, float r, float g, float b) {
        this(readOnly, r, g, b, -1.0f);
    }

    public Colorf(boolean readOnly, float intensity) {
        this(readOnly, intensity, intensity, intensity);
    }

    public Colorf(boolean readOnly, float[] values) {
        this(readOnly, values[0], values[1], values[2], values.length > 3 ? values[3] : -1.0f);
    }

    public Colorf(boolean readOnly, Colorf color) {
        this(readOnly, color.values);
        this.hasAlpha = color.hasAlpha;
    }

    public Colorf(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f, -1.0f);
    }

    public Colorf(boolean readOnly, Color color) {
        this.values = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.values[0] = (float)color.getRed() / 255.0f;
        this.values[1] = (float)color.getGreen() / 255.0f;
        this.values[2] = (float)color.getBlue() / 255.0f;
        boolean bl = this.hasAlpha = color.getAlpha() < 255;
        if (this.hasAlpha) {
            this.values[3] = (float)(255 - color.getAlpha()) / 255.0f;
        }
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
    }

    public Colorf(float r, float g, float b, float a) {
        this(false, r, g, b, a);
    }

    public Colorf(float r, float g, float b) {
        this(false, r, g, b);
    }

    public Colorf(float intensity) {
        this(false, intensity);
    }

    public Colorf(float[] values) {
        this(false, values);
    }

    public Colorf(Colorf color) {
        this(false, color);
    }

    public Colorf() {
        this(false);
    }

    public Colorf(Color color) {
        this(false, color);
    }

    public static Colorf parseColor(String hexString, Colorf buffer) {
        ColorUtil.hexToColor(hexString, buffer);
        return buffer;
    }

    public static Colorf parseColor(String hexString, float alpha) {
        return Colorf.parseColor(hexString, new Colorf(0.0f, 0.0f, 0.0f, alpha));
    }

    public static Colorf parseColor(String hexString) {
        return Colorf.parseColor(hexString, -1.0f);
    }

    public static Colorf parseReadOnlyColor(String hexString, float alpha) {
        float[] values = new float[4];
        ColorUtil.hexToColor(hexString, values);
        values[3] = alpha;
        return new Colorf(true, values);
    }

    public static Colorf parseReadOnlyColor(String hexString) {
        return Colorf.parseReadOnlyColor(hexString, -1.0f);
    }

    public static Colorf fromPool() {
        return POOL.alloc();
    }

    public static Colorf fromPool(float r, float g, float b, float a) {
        return POOL.alloc(r, g, b, a);
    }

    public static Colorf fromPool(float r, float g, float b) {
        return POOL.alloc(r, g, b);
    }

    public static Colorf fromPool(Colorf color) {
        if (color.hasAlpha()) {
            return Colorf.fromPool(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return Colorf.fromPool(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static void toPool(Colorf o) {
        POOL.free(o);
    }
}

