/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.surface;

import org.openmali.FastMath;

public class LinearTerrainHeight {
    public static float evaluateZ(float[][] height, float hx, float hy, float x, float y) {
        int py;
        int my;
        int px;
        y /= hy;
        int mx = (int)FastMath.floor(x /= hx);
        if (mx == (px = (int)FastMath.ceil(x))) {
            ++px;
        }
        if ((my = (int)FastMath.floor(y)) == (py = (int)FastMath.ceil(y))) {
            ++py;
        }
        float e1 = LinearTerrainHeight.getZ(height, mx, py) * (1.0f - (x - (float)mx)) + LinearTerrainHeight.getZ(height, px, py) * (1.0f - ((float)px - x));
        float e2 = LinearTerrainHeight.getZ(height, mx, my) * (1.0f - (x - (float)mx)) + LinearTerrainHeight.getZ(height, px, my) * (1.0f - ((float)px - x));
        float h = e1 * (1.0f - ((float)py - y)) + e2 * (1.0f - (y - (float)my));
        return h;
    }

    public static int getDimX(float[][] height) {
        return height[0].length;
    }

    public static int getDimY(float[][] height) {
        return height.length;
    }

    public static float getZ(float[][] height, int x, int y) {
        float z = 0.0f;
        int rx = Math.min(x, LinearTerrainHeight.getDimX(height) - 1);
        rx = Math.max(rx, 0);
        int ry = Math.min(y, LinearTerrainHeight.getDimY(height) - 1);
        ry = Math.max(ry, 0);
        try {
            z = height[rx][ry];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return z;
    }
}

