/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.octree;

import org.openmali.spatial.FrustumInterface;
import org.openmali.spatial.SpatialCallback;
import org.openmali.spatial.SpatialHandle;
import org.openmali.spatial.VertexContainer;
import org.openmali.spatial.Visibility;
import org.openmali.spatial.octree.OcCallback;
import org.openmali.spatial.octree.OcCell;
import org.openmali.spatial.octree.OcCuller;
import org.openmali.spatial.octree.OcNode;
import org.openmali.spatial.octree.OcRadiusCuller;
import org.openmali.spatial.octree.OcRadiusFrustumCuller;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OcTree<T> {
    protected int worldSize;
    protected int minCellSize;
    protected long numObjects = 0L;
    protected long totalDepth = 0L;
    private OcCell<T> root;

    public OcTree(int worldSize, int minCellSize) {
        this.worldSize = worldSize;
        this.minCellSize = minCellSize;
        this.root = new OcCell(this, null, 0.0f, 0.0f, 0.0f, 0);
    }

    public SpatialHandle<T> insert(float x, float y, float z, float r, T o) {
        OcNode<T> node = new OcNode<T>(x, y, z, r, o);
        this.root.insert(this, node, 0);
        return node;
    }

    public int getAverageDepth() {
        if (this.numObjects == 0L) {
            return 0;
        }
        return (int)(this.totalDepth / this.numObjects);
    }

    public int getNumObjects() {
        return (int)this.numObjects;
    }

    public SpatialHandle<T> insert(Point3f c, float r, T o) {
        OcNode<T> node = new OcNode<T>(c, r, o);
        this.root.insert(this, node, 0);
        return node;
    }

    public SpatialHandle<T> insert(T o, VertexContainer source) {
        OcNode<T> node = new OcNode<T>(o, source);
        this.root.insert(this, node, 0);
        return node;
    }

    public void findWithinSphere(Tuple3f center, float radius, SpatialCallback<T> callback) {
        this.root.traverse(new OcRadiusCuller(center, radius), new GetWithinSphere(callback));
    }

    public void traverse(OcCuller<T> culler, OcCallback<T> callback) {
        this.root.traverse(culler, callback);
    }

    public void findWithinSphere(Tuple3f center, float radius, FrustumInterface frustum, SpatialCallback<T> callback) {
        this.root.traverse(new OcRadiusFrustumCuller(center, radius, frustum), new GetWithinSphere(callback));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetWithinSphere
    implements OcCallback<T> {
        private SpatialCallback<T> callback;

        public GetWithinSphere(SpatialCallback<T> callback) {
            this.callback = callback;
        }

        @Override
        public void hit(Visibility visibility, OcNode<T> node) {
            this.callback.hit(node);
        }

        @Override
        public void done() {
        }
    }
}

