/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.octree;

import org.openmali.spatial.FrustumInterface;
import org.openmali.spatial.Visibility;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.octree.OcNode;
import org.openmali.spatial.octree.OcRadiusCuller;
import org.openmali.vecmath2.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OcRadiusFrustumCuller<T>
extends OcRadiusCuller<T> {
    private FrustumInterface frustum;
    private BoundingSphere bounds;

    @Override
    public Visibility checkNode(OcNode<T> node) {
        if (super.checkNode(node) == Visibility.NOT_VISIBLE) {
            return Visibility.NOT_VISIBLE;
        }
        this.bounds.setCenter(node.getCenter());
        this.bounds.setRadius(node.getRadius());
        if (this.frustum.getVisibility(this.bounds) == Visibility.NOT_VISIBLE) {
            return Visibility.NOT_VISIBLE;
        }
        return Visibility.FULLY_VISIBLE;
    }

    public OcRadiusFrustumCuller(Tuple3f center, float radius, FrustumInterface frustum) {
        super(center, radius);
        this.bounds = new BoundingSphere(0.0f, 0.0f, 0.0f, radius);
        this.frustum = frustum;
    }
}

