/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.octree;

import org.openmali.spatial.Visibility;
import org.openmali.spatial.octree.OcCallback;
import org.openmali.spatial.octree.OcCuller;
import org.openmali.spatial.octree.OcNode;
import org.openmali.spatial.octree.OcTree;
import org.openmali.vecmath2.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OcCell<T> {
    private OcCell<T> parent = null;
    private OcCell<T>[] child;
    public float cx;
    public float cy;
    public float cz;
    public float halfSize;
    private OcNode<T> objects = null;

    public OcCell<T> getParent() {
        return this.parent;
    }

    public boolean fitsInBox(Tuple3f c, float radius, float cx, float cy, float cz, float HalfSize) {
        return !(c.getX() - radius < cx - HalfSize || c.getX() + radius > cx + HalfSize || c.getY() - radius < cy - HalfSize || c.getY() + radius > cy + HalfSize || c.getZ() - radius < cz - HalfSize) && !(c.getZ() + radius > cz + HalfSize);
    }

    public boolean fitsInBox(OcNode<T> o, float cx, float cy, float cz, float halfSize) {
        return this.fitsInBox(o.getCenter(), o.getRadius(), cx, cy, cz, halfSize);
    }

    void insert(OcTree<T> tree, OcNode<T> o, int depth) {
        if (this.halfSize > (float)tree.minCellSize) {
            float QuarterSize;
            float offset = QuarterSize = this.halfSize / 2.0f;
            int j = 0;
            while (j < 2) {
                int i = 0;
                while (i < 2) {
                    int k = 0;
                    while (k < 2) {
                        float cx = this.cx + (i == 0 ? -offset : offset);
                        float cy = this.cy + (k == 0 ? -offset : offset);
                        float cz = this.cz + (j == 0 ? -offset : offset);
                        int index = i * 2 + j + k * 4;
                        if (this.fitsInBox(o, cx, cy, cz, QuarterSize)) {
                            if (this.child[index] == null) {
                                this.child[index] = new OcCell<T>(tree, this, cx, cy, cz, depth + 1);
                            }
                            this.child[index].insert(tree, o, depth + 1);
                            return;
                        }
                        ++k;
                    }
                    ++i;
                }
                ++j;
            }
        }
        ++tree.numObjects;
        tree.totalDepth += (long)depth;
        o.next = this.objects;
        this.objects = o;
    }

    public String getName() {
        StringBuffer sb = new StringBuffer(50);
        sb.append("OcCell (");
        sb.append(Float.toString(this.cx));
        sb.append(',');
        sb.append(Float.toString(this.cy));
        sb.append(',');
        sb.append(Float.toString(this.cz));
        sb.append(") halfsize=");
        sb.append(Float.toString(this.halfSize));
        return sb.toString();
    }

    void traverse(OcCuller<T> culler, OcCallback<T> callback) {
        if (culler.checkCell(this) == Visibility.NOT_VISIBLE) {
            return;
        }
        OcNode<T> o = this.objects;
        while (o != null) {
            Visibility v = culler.checkNode(o);
            if (v != Visibility.NOT_VISIBLE && callback != null) {
                callback.hit(v, o);
            }
            o = o.next;
        }
        int j = 0;
        while (j < 8) {
            if (this.child[j] != null) {
                this.child[j].traverse(culler, callback);
            }
            ++j;
        }
    }

    public OcCell() {
    }

    public OcCell(OcTree<T> tree, OcCell<T> p, float x, float y, float z, int d) {
        this.parent = p;
        this.cx = x;
        this.cy = y;
        this.cz = z;
        this.halfSize = tree.worldSize / (2 << d);
        this.child = new OcCell[8];
        int j = 0;
        while (j < 8) {
            if (this.child[j] != null) {
                this.child[j] = null;
            }
            ++j;
        }
        this.objects = null;
    }
}

