/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bounds;

import java.util.List;
import org.openmali.errorhandling.UnsupportedFunction;
import org.openmali.spatial.VertexContainer;
import org.openmali.spatial.VertexList;
import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bodies.ConvexHull;
import org.openmali.spatial.bodies.IntersectionFactory;
import org.openmali.spatial.bodies.Sphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundingBox
extends Box
implements Bounds {
    private static final long serialVersionUID = 6353321413525340703L;
    private VertexList vertexList = new VertexList();

    @Override
    public final BoundsType getType() {
        return BoundsType.AABB;
    }

    @Override
    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection, Tuple3f intersection) {
        return IntersectionFactory.boxIntersectsRay(this.getLower(), this.getUpper(), rayOrigin, rayDirection, intersection);
    }

    @Override
    public boolean intersects(Ray3f ray, Tuple3f intersection) {
        return this.intersects(ray.getOrigin(), ray.getDirection(), intersection);
    }

    @Override
    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        return this.intersects(rayOrigin, rayDirection, null);
    }

    @Override
    public boolean intersects(Ray3f ray) {
        return this.intersects(ray, null);
    }

    @Override
    public boolean intersects(Bounds bo) {
        if (bo instanceof Box) {
            return IntersectionFactory.boxIntersectsBox((Box)((Object)bo), this);
        }
        if (bo instanceof Sphere) {
            return IntersectionFactory.sphereIntersectsBox((Sphere)((Object)bo), this);
        }
        if (bo instanceof ConvexHull) {
            throw new Error("ConvexHull not supported yet");
        }
        throw new Error("unknown Bounds type");
    }

    @Override
    public boolean intersects(Bounds[] bos) {
        int i = 0;
        while (i < bos.length) {
            if (this.intersects(bos[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Bounds closestIntersection(Bounds[] boundsObjects) {
        throw new UnsupportedFunction();
    }

    @Override
    public void transform(Matrix4f trans) {
        Point3f l = this.getLower();
        Point3f u = this.getUpper();
        float lx = l.getX();
        float ly = l.getY();
        float lz = l.getZ();
        float ux = u.getX();
        float uy = u.getY();
        float uz = u.getZ();
        Point3f p = Point3f.fromPool();
        p.set(lx, ly, lz);
        trans.transform(p);
        this.setLower(p);
        this.setUpper(p);
        p.set(lx, ly, uz);
        trans.transform(p);
        this.combine_(p);
        p.set(lx, uy, lz);
        trans.transform(p);
        this.combine_(p);
        p.set(lx, uy, uz);
        trans.transform(p);
        this.combine_(p);
        p.set(ux, ly, lz);
        trans.transform(p);
        this.combine_(p);
        p.set(ux, ly, uz);
        trans.transform(p);
        this.combine_(p);
        p.set(ux, uy, lz);
        trans.transform(p);
        this.combine_(p);
        p.set(ux, uy, uz);
        trans.transform(p);
        this.combine_(p);
        Point3f.toPool(p);
        this.calcCenter();
        this.setMaxSquaredDistance(this.getLower().distanceSquared(this.getCenter()));
    }

    @Override
    public void transform(Bounds bounds, Matrix4f trans) {
        this.set(bounds);
        this.transform(trans);
    }

    @Override
    public void set(Bounds bo) {
        if (bo instanceof Box) {
            BoundingBox b = (BoundingBox)bo;
            this.setLower(b.getLower());
            this.setUpper(b.getUpper());
            this.calcCenter();
            this.setMaxSquaredDistance(this.getLower().distanceSquared(this.getCenter()));
        } else if (bo instanceof Sphere) {
            Sphere s = (Sphere)((Object)bo);
            this.setLower(s.getCenterX() - s.getRadius(), s.getCenterY() - s.getRadius(), s.getCenterZ() - s.getRadius());
            this.setUpper(s.getCenterX() + s.getRadius(), s.getCenterY() + s.getRadius(), s.getCenterZ() + s.getRadius());
            this.calcCenter();
            this.setMaxSquaredDistance(this.getLower().distanceSquared(this.getCenter()));
        } else {
            if (bo instanceof ConvexHull) {
                throw new Error("ConvexHull not supported yet");
            }
            throw new Error("unknown bounds type");
        }
    }

    @Override
    public void set(Bounds[] bos) {
        if (bos.length > 0) {
            this.set(bos[0]);
        }
        int i = 1;
        while (i < bos.length) {
            this.combine(bos[i]);
            ++i;
        }
    }

    private final void computeAABB(VertexContainer source) {
        int n = source.getVertexCount();
        this.setLower(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        this.setUpper(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Point3f coord = Point3f.fromPool();
        int i = 0;
        while (i < n) {
            source.getVertex(i, coord);
            if (coord.getX() < this.lower.getX()) {
                this.lower.setX(coord.getX());
            } else if (coord.getX() > this.upper.getX()) {
                this.upper.setX(coord.getX());
            }
            if (coord.getY() < this.lower.getY()) {
                this.lower.setY(coord.getY());
            } else if (coord.getY() > this.upper.getY()) {
                this.upper.setY(coord.getY());
            }
            if (coord.getZ() < this.lower.getZ()) {
                this.lower.setZ(coord.getZ());
            } else if (coord.getZ() > this.upper.getZ()) {
                this.upper.setZ(coord.getZ());
            }
            ++i;
        }
        Point3f.toPool(coord);
        this.calcCenter();
        this.setMaxSquaredDistance(this.getLower().distanceSquared(this.getCenter()));
    }

    @Override
    public void compute(VertexContainer source) {
        this.computeAABB(source);
    }

    @Override
    public void compute(List<Tuple3f> coords) {
        this.vertexList.set(coords);
        this.compute(this.vertexList);
    }

    @Override
    public void compute(Tuple3f[] coords) {
        this.vertexList.set(coords);
        this.compute(this.vertexList);
    }

    @Override
    public String toString() {
        return "Bounding" + super.toString();
    }

    public BoundingBox() {
    }

    public BoundingBox(Tuple3f lower, Tuple3f upper) {
        super(lower, upper);
    }

    public BoundingBox(Bounds bo) {
        this.set(bo);
    }

    public BoundingBox(Bounds[] bos) {
        this.set(bos);
    }

    public static BoundingBox newAABB(VertexContainer source) {
        BoundingBox bb = new BoundingBox();
        bb.compute(source);
        return bb;
    }

    public static BoundingBox newAABB(List<Tuple3f> coords) {
        BoundingBox bb = new BoundingBox();
        bb.compute(coords);
        return bb;
    }

    public static BoundingBox newAABB(Tuple3f[] coords) {
        BoundingBox bb = new BoundingBox();
        bb.compute(coords);
        return bb;
    }
}

