/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bodies;

import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class Line {
    private Point3f origin;
    private Vector3f direction;

    public Point3f getOrigin() {
        return this.origin;
    }

    public void setOrigin(float x, float y, float z) {
        this.origin.setX(x);
        this.origin.setY(y);
        this.origin.setZ(z);
    }

    public void setOrigin(Tuple3f origin) {
        this.setOrigin(origin.getX(), origin.getY(), origin.getZ());
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(float x, float y, float z) {
        this.direction.setX(x);
        this.direction.setY(y);
        this.direction.setZ(z);
    }

    public void setDirection(Tuple3f direction) {
        this.setDirection(direction.getX(), direction.getY(), direction.getZ());
    }

    public float getLength() {
        return this.direction.length();
    }

    public float length() {
        return this.direction.length();
    }

    public Line clone() {
        return new Line(this);
    }

    public void set(Point3f origin, Vector3f direction) {
        this.origin.set((TupleNf)origin);
        this.direction.set((TupleNf)direction);
    }

    public void set(Line line) {
        this.set(line.getOrigin(), line.getDirection());
    }

    public boolean equals(Line line) {
        return ((TupleNf)this.origin).equals(line.origin) && ((TupleNf)this.direction).equals(line.direction);
    }

    public boolean equals(Object o) {
        if (o instanceof Line) {
            return this.equals((Line)o);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + "origin=(" + this.origin.getX() + ", " + this.origin.getY() + ", " + this.origin.getZ() + "), " + "direction=(" + this.direction.getX() + ", " + this.direction.getY() + ", " + this.direction.getZ() + ")";
    }

    public Line(float origX, float origY, float origZ, float direcX, float direcY, float direcZ) {
        this.origin = new Point3f(origX, origY, origZ);
        this.direction = new Vector3f(direcX, direcY, direcZ);
    }

    public Line(Point3f origin, Vector3f direction) {
        this(origin.getX(), origin.getY(), origin.getZ(), direction.getX(), direction.getY(), direction.getZ());
    }

    public Line() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Line(Line template) {
        this();
        this.set(template);
    }
}

