/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bodies;

import java.io.Serializable;
import org.openmali.FastMath;
import org.openmali.spatial.bodies.Body;
import org.openmali.spatial.bodies.Classifier;
import org.openmali.spatial.bodies.ConvexHull;
import org.openmali.spatial.bodies.Sphere;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;

public class Box
implements Serializable,
Body {
    private static final long serialVersionUID = -6277131116550693278L;
    private Point3f center = new Point3f();
    protected Point3f lower = new Point3f();
    protected Point3f upper = new Point3f();
    private float maxSquaredDistance = 0.0f;
    private boolean hasPlainDist = false;
    private float maxDistance = 0.0f;
    private Tuple3f size = new Tuple3f();

    public final boolean contains(float px, float py, float pz) {
        return Classifier.classifyBoxPoint(this, px, py, pz) == Classifier.Classification.INSIDE;
    }

    public final boolean contains(Point3f point) {
        return this.contains(point.getX(), point.getY(), point.getZ());
    }

    private final void check() {
    }

    protected final void calcCenter() {
        this.center.set((this.lower.getX() + this.upper.getX()) / 2.0f, (this.lower.getY() + this.upper.getY()) / 2.0f, (this.lower.getZ() + this.upper.getZ()) / 2.0f);
    }

    public final void set(float lowerX, float lowerY, float lowerZ, float upperX, float upperY, float upperZ) {
        this.lower.set(lowerX, lowerY, lowerZ);
        this.upper.set(upperX, upperY, upperZ);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
        this.check();
    }

    public final void set(Tuple3f lower, Tuple3f upper) {
        this.lower.set((TupleNf)lower);
        this.upper.set((TupleNf)upper);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
        this.check();
    }

    public final void setLower(float x, float y, float z) {
        this.lower.set(x, y, z);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
        this.check();
    }

    public final void setLower(Tuple3f point) {
        this.setLower(point.getX(), point.getY(), point.getZ());
    }

    public final void setLowerX(float x) {
        this.lower.setX(x);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
    }

    public final void setLowerY(float y) {
        this.lower.setY(y);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
    }

    public final void setLowerZ(float z) {
        this.lower.setZ(z);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
    }

    public final Point3f getLower() {
        return this.lower;
    }

    public final void getLower(Tuple3f point) {
        point.set((TupleNf)this.lower);
    }

    public final float getLowerX() {
        return this.lower.getX();
    }

    public final float getLowerY() {
        return this.lower.getY();
    }

    public final float getLowerZ() {
        return this.lower.getZ();
    }

    public final void setUpper(float x, float y, float z) {
        this.upper.set(x, y, z);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
        this.check();
    }

    public final void setUpper(Tuple3f point) {
        this.setUpper(point.getX(), point.getY(), point.getZ());
    }

    public final void setUpperX(float x) {
        this.upper.setX(x);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
    }

    public final void setUpperY(float y) {
        this.upper.setY(y);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
    }

    public final void setUpperZ(float z) {
        this.upper.setZ(z);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
    }

    public final Point3f getUpper() {
        return this.upper;
    }

    public final void getUpper(Tuple3f point) {
        point.set((TupleNf)this.upper);
    }

    public final float getUpperX() {
        return this.upper.getX();
    }

    public final float getUpperY() {
        return this.upper.getY();
    }

    public final float getUpperZ() {
        return this.upper.getZ();
    }

    public final float getXSpan() {
        return this.upper.getX() - this.lower.getX();
    }

    public final float getYSpan() {
        return this.upper.getY() - this.lower.getY();
    }

    public final float getZSpan() {
        return this.upper.getZ() - this.lower.getZ();
    }

    public final void setCenter(float x, float y, float z) {
        float xSpan = this.getXSpan();
        float ySpan = this.getYSpan();
        float zSpan = this.getZSpan();
        this.lower.setX(x - xSpan / 2.0f);
        this.lower.setY(y - ySpan / 2.0f);
        this.lower.setZ(z - zSpan / 2.0f);
        this.center.set(x, y, z);
    }

    public final void setCenter(Tuple3f point) {
        this.setCenter(point.getX(), point.getY(), point.getZ());
    }

    public final float getCenterX() {
        return this.center.getX();
    }

    public final float getCenterY() {
        return this.center.getY();
    }

    public final float getCenterZ() {
        return this.center.getZ();
    }

    public final Tuple3f getCenter(Tuple3f out) {
        out.set((TupleNf)this.center);
        return out;
    }

    public final Point3f getCenter() {
        return this.center;
    }

    protected final void setMaxSquaredDistance(float distSq) {
        this.maxSquaredDistance = distSq;
        this.hasPlainDist = false;
    }

    public final float getMaxSquaredDistance() {
        return this.maxSquaredDistance;
    }

    public final float getMaxDistance() {
        if (!this.hasPlainDist) {
            this.maxDistance = FastMath.sqrt(this.maxSquaredDistance);
            this.hasPlainDist = true;
        }
        return this.maxDistance;
    }

    public final void setSize(float xSpan, float ySpan, float zSpan) {
        this.lower.set(this.center.getX() - xSpan / 2.0f, this.center.getY() - ySpan / 2.0f, this.center.getZ() - zSpan / 2.0f);
        this.upper.set(this.center.getX() + xSpan / 2.0f, this.center.getY() + ySpan / 2.0f, this.center.getZ() + zSpan / 2.0f);
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
    }

    public final void setSize(Tuple3f span) {
        this.setSize(span.getX(), span.getY(), span.getZ());
    }

    public final void getSize(Tuple3f out) {
        out.set(this.getXSpan(), this.getYSpan(), this.getZSpan());
    }

    public final Tuple3f getSize() {
        this.size.set(this.getXSpan(), this.getYSpan(), this.getZSpan());
        return this.size;
    }

    public final void combine(Body body) {
        if (body instanceof Box) {
            Box box = (Box)body;
            this.combine_(box.getLower());
            this.combine_(box.getUpper());
            this.calcCenter();
            this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
        } else if (body instanceof Sphere) {
            Sphere s = (Sphere)body;
            this.combine_(s.getCenterX() - s.getRadius(), s.getCenterY() - s.getRadius(), s.getCenterZ() - s.getRadius());
            this.combine_(s.getCenterX() + s.getRadius(), s.getCenterY() + s.getRadius(), s.getCenterZ() + s.getRadius());
            this.calcCenter();
            this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
        } else {
            if (body instanceof ConvexHull) {
                throw new Error("ConvexHull not supported yet");
            }
            throw new Error("Unknown Body type");
        }
    }

    public final void combine(Body[] bodies) {
        int i = 0;
        while (i < bodies.length) {
            this.combine(bodies[i]);
            ++i;
        }
    }

    protected final void combine_(float x, float y, float z) {
        if (x < this.lower.getX()) {
            this.lower.setX(x);
        } else if (x > this.upper.getX()) {
            this.upper.setX(x);
        }
        if (y < this.lower.getY()) {
            this.lower.setY(y);
        } else if (y > this.upper.getY()) {
            this.upper.setY(y);
        }
        if (z < this.lower.getZ()) {
            this.lower.setZ(z);
        } else if (z > this.upper.getZ()) {
            this.upper.setZ(z);
        }
    }

    public final void combine(float x, float y, float z) {
        this.combine_(x, y, z);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
    }

    protected final void combine_(Point3f p) {
        this.combine_(p.getX(), p.getY(), p.getZ());
    }

    public final void combine(Point3f p) {
        this.combine(p.getX(), p.getY(), p.getZ());
    }

    public final void combine(Point3f[] points) {
        int i = 0;
        while (i < points.length) {
            this.combine_(points[i]);
            ++i;
        }
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("Box [ lower: (");
        sb.append(this.lower.getX());
        sb.append(", ");
        sb.append(this.lower.getY());
        sb.append(", ");
        sb.append(this.lower.getZ());
        sb.append("), upper: (");
        sb.append(this.upper.getX());
        sb.append(", ");
        sb.append(this.upper.getY());
        sb.append(", ");
        sb.append(this.upper.getZ());
        sb.append("), span: (");
        sb.append(this.getXSpan());
        sb.append(", ");
        sb.append(this.getYSpan());
        sb.append(", ");
        sb.append(this.getZSpan());
        sb.append(") ]");
        return sb.toString();
    }

    public Box(float lowerX, float lowerY, float lowerZ, float upperX, float upperY, float upperZ) {
        this.lower.set(lowerX, lowerY, lowerZ);
        this.upper.set(upperX, upperY, upperZ);
        this.calcCenter();
        this.setMaxSquaredDistance(this.lower.distanceSquared(this.center));
    }

    public Box(Tuple3f lower, Tuple3f upper) {
        this(lower.getX(), lower.getY(), lower.getZ(), upper.getX(), upper.getY(), upper.getZ());
    }

    public Box() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }
}

