/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial;

import java.util.List;
import org.openmali.spatial.VertexContainer;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VertexList
implements VertexContainer {
    private VertexContainer vc = null;
    private List<Tuple3f> list = null;
    private Tuple3f[] array = null;
    private SourceType sourceType = null;

    public final SourceType getSourceType() {
        return this.sourceType;
    }

    @Override
    public int getVertexCount() {
        switch (this.getSourceType()) {
            case CONTAINER: {
                return this.vc.getVertexCount();
            }
            case LIST: {
                return this.list.size();
            }
            case ARRAY: {
                return this.array.length;
            }
        }
        return -1;
    }

    @Override
    public final boolean getVertex(int i, Tuple3f coord) {
        assert (i >= 0 && i < this.getVertexCount()) : "I must be >= 0 and < getVertexCount()";
        assert (coord != null) : "coord must not be null";
        if (this.getSourceType() == null) {
            return false;
        }
        switch (this.getSourceType()) {
            case CONTAINER: {
                this.vc.getVertex(i, coord);
                return true;
            }
            case LIST: {
                coord.set((TupleNf)this.list.get(i));
                return true;
            }
            case ARRAY: {
                coord.set((TupleNf)this.array[i]);
                return true;
            }
        }
        return false;
    }

    public final void set(VertexContainer vc) {
        this.vc = vc;
        this.list = null;
        this.array = null;
        this.sourceType = SourceType.CONTAINER;
    }

    public final void set(List<Tuple3f> list) {
        this.vc = null;
        this.list = list;
        this.array = null;
        this.sourceType = SourceType.LIST;
    }

    public final void set(Tuple3f[] array) {
        this.vc = null;
        this.list = null;
        this.array = array;
        this.sourceType = SourceType.ARRAY;
    }

    public VertexList() {
    }

    public VertexList(VertexContainer vc) {
        this();
        this.set(vc);
    }

    public VertexList(List<Tuple3f> list) {
        this();
        this.set(list);
    }

    public VertexList(Tuple3f[] array) {
        this();
        this.set(array);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceType {
        CONTAINER,
        LIST,
        ARRAY;

    }
}

