#!/bin/sh

exe=JXCirrusFinance
product="JXCirrus Finance"
script=$0
scriptOnly=`basename $0`
scriptDir=`dirname $0`
if [ "$scriptDir" = "" ]
then
    scriptDir=.
fi

usage () {
    echo "Usage: $scriptOnly TargetDir"
    echo
    echo "   TargetDir = The directory to install $product to."
}

while [ $# -gt 0 ]
do
    if [ $1 = "-h" ]
    then
        usage
        exit 0
    else
        targetDir=$1
    fi
    shift
done

if [ "$targetDir" = "" ]
then
    echo "ERROR: Please supply the target directory."
    echo
    usage
    exit 1
fi

mkdir -p $targetDir
if [ -d $targetDir ]
then
    echo "Installing to $targetDir"
else
    echo "ERROR: Unable to create directory $targetDir"
    exit 1
fi
if [ -w $targetDir ]
then
    echo
else
    echo "ERROR: Unable to write to directory $targetDir"
    exit 1
fi

cd $scriptDir

echo "Press Enter to view the License Agreement"
read ans
echo "------------------------------------------------------------------------"
cat eula.txt
echo "------------------------------------------------------------------------"
while true
do
    echo "Type \"A\" to Accept or \"D\" to Decline"
    read ans
    case $ans in
        [Aa]*)
            break
            ;;
        [Dd]*)
            echo "Aborting installation."
            exit 0
            ;;
    esac
done

echo "Installing..."
if [ "$targetDir" != "." ]
then
    cp -r * $targetDir
fi

cd $targetDir
bin/$exe --register

echo "Installation of $product is now complete."
echo " The full path to the executable is:"
echo " $targetDir/bin/$exe"
