#-------------------------------------------------------------------------------
# rev.py
# This is a tool for updating the revision of pyFlashCards.  The new revision
# will be stored in rev.cfg
#
# Author:   Marcin Matuszkiewicz
#-------------------------------------------------------------------------------
# pyFlashCards is a multiplatform flash cards software.
# Copyright (C) 2006  Marcin Matuszkiewicz
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
#   Foundation, Inc.
#   51 Franklin Street, Fifth Floor
#   Boston
#   MA  02110-1301
#   USA.
#-------------------------------------------------------------------------------
# CVS information
# $Source:$
# $Revision:$
# $Date:$
# $Author:$
#-------------------------------------------------------------------------------
import getopt, sys
import ConfigParser

from string import *

major = 0
minor = 0
build = 0

warning = "This file is autogenerated.  Any changes will be lost."

def main():
    global major, minor, build

    if len(sys.argv) == 1:
        usage()
        sys.exit()

    config = ConfigParser.ConfigParser()
    config.read('rev.cfg')

    # parse configuration file
    try:
        major = int(config.get('rev', 'major'))
        minor = int(config.get('rev', 'minor'))
        build = int(config.get('rev', 'build'))
    except ConfigParser.NoSectionError, sec:
        print sec
    except ConfigParser.NoOptionError, opt:
        print opt



    try:
        opts, args = getopt.getopt(sys.argv[1:], "",
                            ['help', 'major', 'minor', 'build', 'disp'])
    except getopt.GetoptError:
        usage()
        sys.exit(1)

    for o, a in opts:
        if o == '--help':
            usage()
            sys.exit()

        if o == '--major':
            major += 1
            minor = 0
            build = 0

        if o == '--minor':
            minor += 1
            build = 0

        if o == '--build':
            build += 1

        if o == '--disp':
            print '%g.%g.%g' % (major, minor, build)
            sys.exit()

    config.set('rev', 'major', major)
    config.set('rev', 'minor', minor)
    config.set('rev', 'build', build)

    fcfg = open('rev.cfg', 'w')
    config.write(fcfg)
    fcfg.close()
    print '%g.%g.%g' % (major, minor, build)

usage_str = """\
Usage: rev OPTION
    --help  this message
    --major major revision
    --minor minor revision
    --build new build
    --disp  print current revision
"""

def usage():
    print usage_str

if __name__ == "__main__":
    main()
