#!/bin/bash

plural()
{
	if (( $1 == 1 ))
		then echo $2
		else echo $3
	fi
}

CHECK_TERMINAL=1
CLOSEMSG='quit'
while (( $# )) ; do
	case "$1" in
		--gui)
			CLOSEMSG='close this window'
			CHECK_TERMINAL=0
		;;
	esac
	shift
done

if (( $CHECK_TERMINAL )) ; then
	if ! tty -s ; then
		if [ -n "${DISPLAY}" ] ; then
			TITLE='-T'
			GUESS_XTERMS="xterm"
			for A in ${GUESS_XTERMS} ; do
				if type ${A} >/dev/null 2>&1 ; then
					XTERM=${A}
					break
				fi
			done
			if [ -z "${XTERM}" ] ; then
				TITLE='--title'
				GUESS_XTERMS="konsole gnome-terminal multi-gnome-terminal"
				for A in ${GUESS_XTERMS} ; do
					if type ${A} >/dev/null 2>&1 ; then
						XTERM=${A}
						break
					fi
				done
			fi
			if [ -z "${XTERM}" ] ; then
				TITLE='-T'
				GUESS_XTERMS="xfce4-terminal aterm Eterm mlterm pterm rxvt mrxvt wterm"
				for A in ${GUESS_XTERMS} ; do
					if type ${A} >/dev/null 2>&1 ; then
						XTERM=${A}
						break
					fi
				done
			fi
			if [ -n "${XTERM}" ] ; then
				${XTERM} "${TITLE}" "DComSoft SWFProtector2 installer" -e "$0 --gui"
				exit
			fi
		fi
	fi
fi


CHECK_FILE=0
rm -f /tmp/DCom_SWFProtector2-installer 2>/dev/null

OLD_DIR=$(pwd)
cd "$(dirname "$0")"

case $(uname -m) in
	x86_64) cd x86_64 ;;
	*) cd i386 ;;
esac


ARCH_LIB=$(ls -1 lib/* | grep '\.so$')
LDD_REP=$(which ldd > /dev/null && ldd ./DCom_SWFProtector2-installer ${ARCH_LIB} 2>/dev/null)
if (( $? )) ; then
	echo -e "Your computer architecture seems to be not supported by this installer."
else
	NOLIBS=$(echo "${LDD_REP}" | grep 'not found' | grep -v 'prot2' | sed -n 's,^	\(.*\) => .*,  \1,p' | sort | uniq)
	if [ -n "$NOLIBS" ] ; then
		NLIB=$(echo "$NOLIBS" | wc -l)
		echo -e "The following $(plural $NLIB 'library was' 'libraries were') not found on your system:\n$NOLIBS\nPlease install $(plural $NLIB 'it' 'them') and try again."
	else
		if [ x"$(id -u)" == x"0" ] ; then
			echo "This installer must be runned from ordinary user account, not root."
		else
			if which sudo > /dev/null ; then
				if [ -z "$SESSION_MANAGER" ] ; then
					export SESSION_MANAGER="local/$(hostname):$(find /tmp/.ICE-unix/ -type s -user $(whoami) | grep -v dcop)"
				fi
				touch /tmp/DCom_SWFProtector2-installer
				if sudo -p "[sudo] password for %u : " -b sh -c "chown \"$(whoami)\" ./DCom_SWFProtector2-installer ; export DESKTOP_SESSION=\"${DESKTOP_SESSION}\" ; export SESSION_MANAGER=\"${SESSION_MANAGER}\" ; export KDE_FULL_SESSION=\"${KDE_FULL_SESSION}\" ; export GTK_RC_FILES=\"${GTK_RC_FILES}\" ; export GTK2_RC_FILES=\"${GTK2_RC_FILES}\" ; export LD_LIBRARY_PATH=./lib ; ./DCom_SWFProtector2-installer" ; then
					CHECK_FILE=1
				fi
			else
				echo "This installer requires 'sudo' program to be installed"
			fi
		fi
	fi
fi

cd "${OLD_DIR}"

if (( ${CHECK_FILE} )) ; then
	while [ -f /tmp/DCom_SWFProtector2-installer ] ; do
		sleep 1s
	done
else
	echo -ne "\rPress 'Enter' to ${CLOSEMSG} ... "
	read
	echo
fi
