/*
 * speed.c
 *
 * (C) 1993 Christoph Niemann
 *
 * niemann@swt.ruhr-uni-bochum.de
 */


#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef __linux
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <linux/b004.h>
#else
#include <conio.h>
#include <io.h>
#include <alloc.h>
#endif

#undef DEBUG

#define BYTE unsigned char

#define ONE_SEC 15625.0
#define K_BYTES 100
#define BUFFER_LENGTH 512

#define PROG_NAME "speed.b4"
#define LINK_NAME "/dev/link0"

#ifndef __linux
#define INT unsigned long int
void reset_link( void )
{
   int i;

#ifdef DEBUG
   printf( "DEBUG: resetting transputer.\n");
#endif

   outp( 0x161, 0 );
   for ( i = 0; i < 10000; i++ );
   outp( 0x160, 0 );
   for ( i = 0; i < 10000; i++ );
   outp( 0x160, 1 );
   for ( i = 0; i < 10000; i++ );
   outp( 0x160, 0 );
   for ( i = 0; i < 10000; i++ );
}

void read_link ( BYTE *buffer, INT Count )
{
   INT n, l ;
   BYTE* temp = buffer;

#ifdef DEBUG
    printf( "DEBUG: reading %u bytes from link ", Count);
#endif
   for( n = 0 ; n < Count ; n++ )
      {
	 for( l = 0 ; !(inp(0x0152) & 1) && (l < 10000); l++);
	 if ( l == 10000 )
	 {
#ifdef DEBUG
	      printf(" - failed at byte no %u", n);
#endif
	      exit(-4);
	 }
	 *temp++ = (BYTE) (inp(0x0150) & 0xff);
       }
#ifdef DEBUG
   printf( " - o.k.\n" );
#endif

}

void write_link ( BYTE* buffer, INT Count)
{
   INT n, l ;
   BYTE * temp = buffer;

#ifdef DEBUG
    printf( "DEBUG: writing %u bytes to link ", Count);
#endif

    for( n = 0 ; n < Count ; n++ )
       {
	 for( l = 0 ; !(inp(0x0153) & 1) && (l < 10000); l++);
	 if ( l == 10000 )
	 {
#ifdef DEBUG
	      printf(" - failed at byte no %u", n);
#endif
	      exit(-5);
	 }
	 outp(0x0151, (*temp++ & 0xff));
       }

#ifdef DEBUG
   printf( " - o.k.\n" );
#endif

}
#else
#define INT int
#endif  /* DOS */



int main( void )
{
  INT Time, len;
  int File;
#ifdef __linux
  INT Link;
#endif
  BYTE *Test, *buf;

  Test = NULL;

#ifdef __linux
  Test = (BYTE *) malloc( K_BYTES * 1024 );
#else
  Test = malloc( K_BYTES * 512 + 10);
#endif

  buf = (BYTE *) malloc( BUFFER_LENGTH );

  if ( (Test == NULL) || (buf == NULL) )
  {
    printf("Not enough memory on host to perform testing.\n");
    exit (-3);
  }

  if ( sizeof(INT) != 4 )
  {
    printf("The storage-size of INT must be 4 bytes\n");
    exit(-6);
  }

#ifdef __linux
  /* open the link */


  if ( ( Link = open(LINK_NAME, O_RDWR ) ) < 0 )
  {
    printf("Unable to open link %s.\n", LINK_NAME);
    exit(-1);
  }
  ioctl(Link, B004RESET, 1); 
#else
  reset_link();
#endif

  /* open the program that has to be sent to transputer's memory */
#ifdef __linux
  if ( (File = open(PROG_NAME, O_RDONLY ) ) < 0 )
#else
  if ( (File = open(PROG_NAME, O_RDONLY | O_BINARY) ) < 0 )
#endif
  {
    printf("Unable to open file %s.\n" , PROG_NAME);
    exit(-2);
  }

  printf(" Booting Transputer ...\n");
  len = read( File, buf, BUFFER_LENGTH );
  while (len > 0)
  {
#ifdef __linux
    write( Link, buf, len );
#else
    write_link(  buf, len );
#endif
    len = read( File, buf, BUFFER_LENGTH );
  }

#ifdef __linux
  write( Link, &Time, 4);
  read( Link, Test, K_BYTES * 1024);
  read( Link, &Time, 4);
#else
  write_link( (BYTE *) &Time, 4);
  read_link(  Test, (INT) K_BYTES * (INT) 512);
  read_link(  Test, (INT) K_BYTES * (INT) 512);
  read_link( (BYTE *) &Time, 4);
#endif
  printf(" Time for reading %d kBytes: %f seconds\n", K_BYTES, (float) Time / ONE_SEC);
  printf(" Data transfer rate for reading: %d kBytes per second\n\n",
		(int) ( (float) K_BYTES * ONE_SEC / ( (float) Time) ) );
#ifdef __linux
  write( Link, &Time, 4);
  write( Link, Test, K_BYTES * 1024);
  read( Link, &Time, 4);
#else
  write_link( (BYTE *) &Time, 4);
  write_link( Test, (INT) K_BYTES * (INT) 512);
  write_link( Test, (INT) K_BYTES * (INT) 512);
  read_link( (BYTE *) &Time, 4);
#endif
  printf(" Time for writing 100 kBytes: %f seconds\n", (float) Time / ONE_SEC);
  printf(" Data transfer rate for writing: %d kBytes per second\n",
		(int) ( (float) K_BYTES * ONE_SEC / ( (float) Time) ) );
  close(File);
#ifdef __linux
  ioctl(Link, B004RESET, 1);
  close(Link);
#endif
  return (1);
}
