/*
   modfiy - this program modifies the files mem.c and Makefile in your
   linux/drivers/char subdirectory. The old files are saved as *~.

   (C) 1993 Christoph Niemann
	    niemann@swt.ruhr-uni-bochum.de

   This version works only with kernel sources >= 0.99pl14 because
   the directory structure has changed.
*/



#include <stdio.h>
#include <string.h>

#define MAKEFILE "/drivers/char/Makefile"
#define MEM	 "/drivers/char/mem.c"
#define LINUX	 "/linux"
#define BAK	 "~"
#define FALSE	 0
#define TRUE	 1
#define MAX_NUMBER 4
#define MAX_STRING 255
#define MAKE_TYPE 1
#define C_TYPE 2
#define ASM_TYPE 3

char inserts[MAX_NUMBER][MAX_STRING] = { "#include <linux/kernel.h>",
			 "#include <linux/b004.h>\n",
			 "mem_start = tty_init",
			 "\tmem_start = b004_init( mem_start );\n"
			 };

void help( void )
{
  puts("This program copies the files of the B004 device drivers to your");
  puts("linux source-directory an modifies the files 'Makefile' and");
  puts("'mem.c' in your chr_drv subdirectory.");
  puts("The only parameter you can give is the root-directory of your linux-");
  puts("sources. By default '/linux' is assumed.");
  exit(-1);
}

char * comment_find(char* str, const char comment[2])
{
  
  char* c = str;

  if ( c == NULL || *c == '\0' ) return NULL;
  while (*(c+1) != '\0')
    if ( *c == comment[0] && *(c+1) == comment[1] )
      return c;
    else 
     c++;
  return NULL;
}

char *read_line( char* string, int type )
{
  static int in_comment = FALSE;
  char   *start, *c1, *c2;
  char   new[MAX_STRING];
  start = string;
  new[0] = '\0';
  while ( *start == ' ' || *start == '\t' ) start++;
  if ( type == C_TYPE)
  {
    if ( in_comment )
      if ( ( c1 = comment_find( start, "*/") ) != NULL )
      {
        start = c1 + 2;
        in_comment = 0;
      }
      else
        *start = '\0';
    if ( !in_comment )
    {
      while ( (!in_comment) && ( ( c1 = comment_find( start, "/*" ) ) != NULL ) )
      {
        in_comment = 1;
        c2 = comment_find( c1 + 2, "*/" );
        if ( c2 != NULL )
        {
          *c1 = '\0';
          strcat( new, start );
          start = c2 + 2;
          in_comment = 0;
        }
      }
      if ( in_comment ) *c1 = '\0';
    }
    strcat(new, start);
  }
  else
  if ( type == MAKE_TYPE )
  {
    if ( *start != '#' )
      strcpy( new, start );
  }
  if (new[strlen(new) - 1] == '\n') 
    new[strlen(new) - 1] = '\0';
  return &new[0];
}

void main( int argc, char *argv[] )
{
  char make_name[MAX_STRING];
  char mem_name[MAX_STRING];
  char make_name_bak[MAX_STRING];
  char mem_name_bak[MAX_STRING];
  char string[MAX_STRING];
  char *new;
  FILE *mem_file = NULL;
  FILE *make_file = NULL;
  FILE *mem_file_new = NULL;
  FILE *make_file_new = NULL;
  int  patched = FALSE;
  int  number = 0;

  if (argc > 2) help();

  if ( argc == 2 )
  {
    strcpy(make_name, argv[1]);
    strcpy(mem_name, argv[1]);
  }
  else
  {
    strcpy(make_name, LINUX );
    strcpy(mem_name, LINUX );
  }
  strcat(make_name, MAKEFILE );
  strcat(mem_name, MEM );
  strcpy(make_name_bak, make_name);
  strcat(make_name_bak, BAK);
  strcpy(mem_name_bak, mem_name);
  strcat(mem_name_bak, BAK);
  if ( rename(make_name, make_name_bak) < 0 || rename(mem_name, mem_name_bak) < 0)
  {
    perror("Rename: ");
    help();
  }
  if ( (!(mem_file = fopen(mem_name_bak, "r"))) || 
       (!(make_file = fopen(make_name_bak, "r"))) )
  {
    perror("Cannot make backups");
    help();
  }
  if ( (!(mem_file_new = fopen(mem_name, "w"))) || 
       (!(make_file_new = fopen(make_name, "w"))) )
  {
    perror("Cannot create the new files");
    help();
  }
  while (!feof(mem_file))
  {
    fgets(string, MAX_STRING, mem_file);
    if ( patched )
    {
      patched = FALSE;
      if ( strcmp( string, inserts[number - 1] ) == 0 )
      {
        printf("The patch is allready applied.\n");
        fclose(mem_file);
        fclose(make_file);
        rename(mem_name_bak, mem_name);
        rename(make_name_bak, make_name);
        exit(-1);
      }
    }
    fputs( string, mem_file_new );
    new = read_line(string, C_TYPE);
    if ( number < MAX_NUMBER && strlen(new) >= strlen(inserts[number]) &&
         strncmp(inserts[number], new, strlen(inserts[number])) == 0)
    {
      fputs(inserts[number + 1], mem_file_new);
      number += 2;
      patched = TRUE;
    }
  } /* mem.c processed */
  fclose(mem_file);
  fclose(mem_file_new);

  while (!feof(make_file))
  {
    fgets( string, MAX_STRING, make_file );
    new = read_line(string, MAKE_TYPE);
    if ( strncmp( new, "OBJS", 4) == 0 && new[strlen(new) - 1] == '\\')
    {
      char *temp = &string[strlen(string) - 2];
      strcpy(temp, " b004.o \\\n");
    }
    if ( strncmp( new, "SRCS", 4) == 0 && new[strlen(new) - 1] == '\\')
    {
      char *temp = &string[strlen(string) - 2];
      strcpy(temp, " b004.c \\\n");
    }
    fputs( string, make_file_new );
  } /* Makefile processed */

  fclose(make_file);
  fclose(make_file_new);

}
