/*
-- ----------------------------------------------------------------------------
--
--  Object name : itermp.c
--  Revision    : 1.0
--
--  Copyright (c) Inmos Ltd, 1987.
--  All Rights Reserved.
--
--  DESCRIPTION
--    TDS Server  IBM implementation-specific term.p
--
--  NOTES
--
--  HISTORY
--     ibm-pc   28-Jul-88  CREATION.
--     ibm-pc   17-Feb-88  RJO Addition of TrackCursor routine.
--     ibm-pc   22-Feb-88  RJO New Keyboard layout for TDS3 added.Table driven
--     keyboard layout.
--     ibm-pc   22-Feb-88  RJO Protocol sends Bytes instead of ints.
--     ibm-pc   23-Feb-88  RJO Added CTRL-Y to return ft.del.line.
--     ibm-pc   24-Feb-88  RJO New TDS3 help map added.
--     ibm-pc   19-Apr-88  RJO Changed TT_KEY_RAW,TT_KEY_COOKED to return a
--     respective FT_ tag.Made HT (Tab) return FT_SELECT_PARAM.Fixed problem
--     with uninitialised variable AbortFlag.
--     ibm-pc   20-May-88  RJO Fixed problem in ClearEos which was 'wrapping
--     around' causing lines to be cut up.
-- ----------------------------------------------------------------------------
*/
#include "stdio.h"
#include "inmos.h"
#include "termp.h"
#include "srvconst.h"
#include "linux-keys.h"
#define NO_OF_HELP_ITEMS 23
/*
-- ----------------------------------------------------------------------------
-- Termp Global Variables.
-- ----------------------------------------------------------------------------
*/

BOOL AbortFlag = FALSE;

/*
-- ----------------------------------------------------------------------------
-- Termp Static Variables.
-- ----------------------------------------------------------------------------
*/

static int TermPRunning, Cx, Cy;
static BOOL WellDone = TRUE;
/*
-- ----------------------------------------------------------------------------
-- TDS Keyboard Help Map.
-- ----------------------------------------------------------------------------
*/
static BYTE *HelpText[NO_OF_HELP_ITEMS] =
  {
" ",
"F1,F2  Help          Fold info            [You must compile linux with the",                     /* Line 1 */
"Shift  Browse        File/Unfile fold     option meta key sends ESC = yes]",              /* Line 2 */
" ",                                                  /* Line 3 */
"F3,F4  Move line     Copy line            Ins  = Create Fold",
"Shift  Put           Copy pick            Home = Enter Fold",
"                                          PgUp = Exit Fold ",
"F5,F6  Get code      Run exe              PgDn = Close Fold",
"Shift  Autoload      Clear all            End  = Open Fold",
" ",
"F7,F8  Start of line End of line          Tab  = Select Parameter",
"Shift  Word left     Word right           Ctrl-A Set abort flag",
"                                          Ctrl-Y Delete line",
"F9,F10 Line up       Line down",
"Shift  Top of fold   Bottom of fold",
" ",
"Alt key with letter:",
"e Enter toolkit      n Next utility       i Code information",
"s Suspend TDS        x Finish             y Undelete Linie",
"l,r,u,d              Word left/right      Page up/down",
"f Remove fold        p Pick line          t Next exe",
"q Delete Line        m Define macro       w Call macro",
"c Clear utility      b Clear exe"
  };

/*
-- ----------------------------------------------------------------------------
-- void TermPInit - Initialise TermP.
--
-- Input Parameters:
--    None.
--
-- Output Parameters:
--    None.
-- ----------------------------------------------------------------------------
*/
void TermPInit()
{
  TermPRunning = TRUE;
  WellDone = TRUE;
  AbortFlag = FALSE;
}
/*
-- ----------------------------------------------------------------------------
-- void TermPToLink
--
-- Input Parameters:
--   (int) x - Word to send.
--
-- Output Parameters:
--   None.
-- ----------------------------------------------------------------------------
*/
void TermPToLink (x)
int x;
{
  ByteToLink (FROM_TERM_P_CHAN);
  WordToLink (x);
}
/*
-- ----------------------------------------------------------------------------
-- void ClearEos - Clear to the end of the Screen.
--
-- Input Parameters:
--  None.
--
-- Output Parameters:
--  None.
-- ----------------------------------------------------------------------------
*/
void ClearEos ()
{
  printf("\033[0J\033[?6h"); fflush(stdout);
}
/*
-- ----------------------------------------------------------------------------
-- void TrackCursor - Update screen.p 's idea of where the cursor is.
--
-- Input Parameters:
--   (int) Ch - Current value of cursor.
--
-- Output Parameters:
--   None.
--
-- NOTES:
-- This will be the same as the actual cursor position unless we recieve
-- characters which are not normal visible characters ( ' ' - '~', cr, lf).
-- ----------------------------------------------------------------------------
*/
void TrackCursor (Ch)
int Ch;
{
  switch (Ch)
    {
      case '\r':
          Cx = 0;
          GotoXY (Cx, Cy);
          break;
      case '\n':
          if (Cy != LAST_SCREEN_LINE)
            Cy++;
          else
            putchar ('\n');
          GotoXY (Cx, Cy);
          break;
      default:
          putchar (Ch);
          Cx++;
          break;
    };
}
/*
-- ----------------------------------------------------------------------------
-- BOOL DoTermPChan - Process message on ToTermP channel.
--
-- Input Parameters:
--  None.
--
-- Output Parameters:
--  (BOOL) result
--
-- ----------------------------------------------------------------------------
*/
BOOL DoTermPChan ()
{
  int Result= T_OK;

  if (TermPRunning)
    {
      int Command = ByteFromLink();

      switch (Command)
        {
          case  TT_RESET:
              Cx = 0; Cy = 0;
              GotoXY (0, 0);
              break;
          case  TT_UP:
              if (Cy)
                GotoXY (Cx, --Cy);
              break;
          case  TT_DOWN:
              GotoXY (Cx, ++Cy);
              break;
          case  TT_LEFT:
              if (Cx)
                GotoXY (--Cx, Cy);
              break;
          case  TT_RIGHT:
              GotoXY (++Cx, Cy);
              break;
          case  TT_CLEAR_EOS:
              ClearEos ();
              break;
          case  TT_CLEAR_EOL:
              printf("\033[0K\033[?6h");
	      GotoXY( Cx, Cy );
              break;
          case  TT_INS_LINE:
              ScrollDown (0, Cy, LAST_TEXT_COL, LAST_TEXT_LINE);
              break;
          case  TT_DEL_LINE:
              ScrollUp(0, Cy, LAST_TEXT_COL, LAST_TEXT_LINE);
              break;
          case  TT_GOTO:
              Cx = WordFromLink();
              Cy = WordFromLink();
              GotoXY (Cx, Cy);
              break;
          case  TT_OUT_STRING:
            {
              int Length;
              BYTE ScreenPBuffer [MAX_STRING_SIZE];
              SliceFromLink (&Length, ScreenPBuffer);
              ScreenPBuffer[Length] = '\0';           /* round off our string nicely */
              if (Length>0)
                {
                  Length = 0;
                  while (ScreenPBuffer[Length] != '\0')
                    TrackCursor (ScreenPBuffer[Length++]);
                }
              break;
            }
          case  TT_OUT_BYTE:
            {
              int Ch = SafeByteFromLink();
              TrackCursor (Ch);
              break;
            }
          case  TT_OUT_INT:
              TrackCursor ((int)WordFromLink());
              break;
          case  TT_TERMINATE:
              TermPRunning = FALSE;
              break;
          case  TT_INS_CHAR:
          case  TT_DEL_CHAR:
          case  TT_BEEP:
              putchar(BELL);
              break;
          case TT_HELP:
            {
              int Length = 0;
              int ScreenPosC, ScreenPosL;
              int NoOfOutputLines = 0;
              BYTE Copy[LAST_TEXT_COL];
              int TDSTitleLen = strlen (TITLE);

              SliceFromLink (&Length, Copy);    /* Get the version string from the TDS */
              Copy[Length] = '\0';
              Cx = 0; Cy = 0;
              GotoXY (0, 0);
              ClearEos ();
              ScreenPosC = (80 - TDSTitleLen)/2;
              ScreenPosL = 0;
              GotoXY (ScreenPosC, ScreenPosL);
              printf ("%s",TITLE);
              ScreenPosC = 0;
              ScreenPosL = 1;
              GotoXY (ScreenPosC, ScreenPosL);
              while (NoOfOutputLines != NO_OF_HELP_ITEMS)
                {
                  GotoXY (ScreenPosC, ScreenPosL++);
                  printf ("%s",HelpText[NoOfOutputLines++]);
                };
              ScreenPosC = (LAST_TEXT_COL - Length)/2;
              GotoXY (ScreenPosC, ++NoOfOutputLines);
              printf ("%s",Copy);
              break;
            }
          case TT_INITIALISE:
              TermPToLink(FT_LINES_PREFIX);
              TermPToLink(LAST_SCREEN_LINE);
              TermPToLink(FT_COLUMNS_PREFIX);
              TermPToLink(LAST_SCREEN_COL);
              TermPToLink(FT_NOLINEOPS_PREFIX);
              TermPToLink(NO_OPS);
              TermPToLink(FT_NOCHAROPS_PREFIX);
              TermPToLink(NO_CHAR_OPS);
              TermPToLink(FT_END_INIT);
              Cx = 0; Cy = 0;
              GotoXY (0, 0);
              break;
          case  TT_KEY_RAW:
              WellDone = FALSE;
              TermPToLink (FT_RAW);
              break;
          case  TT_KEY_COOKED:
              WellDone = TRUE;
              TermPToLink (FT_COOKED);
              break;
          default:
              TermPRunning = FALSE;
              break;
        }
    }
  else
    Result = T_ILLEGAL_SCREEN_P_TOKEN;

  return (Result);
}
/*
-- ----------------------------------------------------------------------------
-- void ReadKey ()
-- Read a key from the keyboard, and send to the TDS using to_TermP
--
-- Input Parameters:
--   None
-- Output Parameters:
--   None.
--
-- Notes:
-- When upgraded to TDS3, a table of Term.p values is used to index into. This
-- makes the code here much more compact and protable.
-- ----------------------------------------------------------------------------
*/
void ReadKey ()
{
  int Ch,i;
  unsigned char Key[8];
  Ch = GetKey();

  if (!WellDone)
    TermPToLink ( Ch );
  else
    {
      if ((MIN_VISIBLE_CHAR <= Ch) && (Ch <= MAX_VISIBLE_CHAR))
        TermPToLink (Ch) ;
      else if (Ch == CTRL_A)
        AbortFlag = TRUE;
      else if (Ch == CTRL_Y)
        TermPToLink (FT_DEL_LINE);
      else
        {
          switch (Ch)
            {
              case BS:     TermPToLink (FT_DEL_CHL); break;
              case CR:     TermPToLink (RETURN); break;
              case HT:     TermPToLink (FT_SELECT_PARAM); break;
              case ESCAPE:
                {
                  int ok = 0;
                  /* Its a Funky Function Key - Get down with some translation..... */
		  for (i = 0; i < 4; i++ )
	              Key[i] = GetKeyNwait();

		  for (i = 0; i < LINUX_KEYS; i++)
		    if ( (keys[i][0] == Key[0]) && (keys[i][1] == Key[1]) &&
			 (keys[i][2] == Key[2]) && (keys[i][3] == Key[3]) )
		    {
		      TermPToLink( keys[i][4] ); 
		      ok = 1;
		      i = LINUX_KEYS;
                    }

                  if ( ok == 0)
                    TermPToLink (FT_BAD);
                  break;
                }
              default:     TermPToLink (FT_BAD);break;
            }
        }
    }
}
