/*{{{}}}*/
/*{{{  Notes*/
/*

This driver was written from scratch by Michael Haardt, adapting the old
iserver driver by Christoph Niemann would have been more work.

Therefore, it is (c) by Michael Haardt, 1993, but it can be distributed
without charge as long as you leave my name in here or state it visible
if you only distribute binary versions.  There are no further conditions
associated with distribution.

*/
/*}}}  */
/*{{{  #includes*/
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <linux/link.h>

#include "linkio.h"
/*}}}  */

/*{{{  B004OpenLink*/
int B004OpenLink(char *Name)
{
  int fd,i;

  if (Name==(char*)0 || *Name=='\0')
  {
    for (i=0; i<3; ++i)
    {
      char buf[20];

      sprintf(buf,"/dev/link%d",i);
      if ((fd=open(buf,O_RDWR))>=0) return fd;
    }
    return ER_LINK_BAD;
  }
  else return (((fd=open(Name,O_RDWR))<0) ? ER_LINK_BAD : fd);
}
/*}}}  */
/*{{{  B004CloseLink*/
int B004CloseLink(int LinkId)
{
  return(close(LinkId)<0 ? ER_LINK_CANT : SUCCEEDED);
}
/*}}}  */
/*{{{  B004ReadLink*/
int B004ReadLink (int LinkId, char *Buffer, unsigned int Count, int Timeout)
{
  int res;

  if (Timeout==0)
  {
    ioctl(LinkId,LINKREADABORT,0);
  }
  else
  {
    ioctl(LinkId,LINKREADABORT,1);
    ioctl(LinkId,LINKREADTIMEOUT,Timeout*10);
  }
  if ((res=read(LinkId, Buffer, Count))==-1)
  {
    if (Timeout==0) return (ER_LINK_CANT);
    else return (errno==EFAULT ? 0 : ER_LINK_CANT);
  }
  return res;
}
/*}}}  */
/*{{{  B004WriteLink*/
int B004WriteLink(int LinkId, char *Buffer, unsigned int Count, int Timeout)
{
  int res;

  if (Timeout==0)
  {
    ioctl(LinkId,LINKWRITEABORT,0);
  }
  else
  {
    ioctl(LinkId,LINKWRITEABORT,1);
    ioctl(LinkId,LINKWRITETIMEOUT,Timeout*10);
  }
  if ((res=write(LinkId, Buffer, Count))==-1)
  {
    if (Timeout==0) return (ER_LINK_CANT);
    else return (errno==EFAULT ? 0 : ER_LINK_CANT);
  }
  return res;
}
/*}}}  */
/*{{{  B004ResetLink*/
int B004ResetLink(int LinkId)
{
  return(ioctl(LinkId, LINKRESET, 1) != 1 ? ER_LINK_CANT : SUCCEEDED);
}
/*}}}  */
/*{{{  B004AnalyseLink*/
int B004AnalyseLink(int LinkId)
{
  return(ioctl(LinkId, LINKANALYSE, 0) != 0 ? ER_LINK_CANT : SUCCEEDED);
}
/*}}}  */
/*{{{  B004TestError*/
int B004TestError(int LinkId)
{
  int res;

  return((res=ioctl(LinkId, LINKERROR, 0))<0 ? ER_LINK_CANT : res);
}
/*}}}  */
/*{{{  B004TestRead*/
int B004TestRead(int LinkId)
{
  int res;

  return((res=ioctl(LinkId, LINKREADABLE, 0))<0 ? ER_LINK_CANT : res);
}
/*}}}  */
/*{{{  B004TestWrite*/
int B004TestWrite(int LinkId)
{
  int res;

  return((res=ioctl(LinkId, LINKWRITEABLE, 0))<0 ? ER_LINK_CANT : res);
}
/*}}}  */
