/*{{{}}}*/
/*{{{  #defines*/
#define FLOAT 1
#define DOUBLE 2

#if TYPE==FLOAT
#define FLT(x) x
#define DBL(x)
#else
#define FLT(x)
#define DBL(x) x
#endif
/*}}}  */

/*{{{  vecdotflt, vecdotdbl*/
FLT(float vecdotflt(float *x, float *y, int n))
DBL(double vecdotdbl(double *x, double *y, int n))
{
#ifdef TRANSPUTER
  /*{{{  res=0.0*/
  FLT(asm(" fpldzerosn")); DBL(asm(" fpldzerodb"));
  /*}}}  */
  /*{{{  if (n==0) goto nowork;*/
  asm(" ldl %n");
  asm(" cj @nowork");  
  /*}}}  */
  /*{{{  if ((n&3)==0) goto loop;*/
  asm(" ldl %y");
  asm(" ldl %n");
  asm(" ldc 3");
  asm(" and");
  asm(" ldl %x");
  asm(" rev");
  asm(" cj @loop");
  /*}}}  */
  /*{{{  res+=*x**y; ++x; ++y; --n; if (n==0) goto nowork*/
  asm(" dup");
  FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
  asm(" rev");
  asm(" dup");
  FLT(asm(" fpldnlmulsn")); DBL(asm(" fpldnlmuldb"));

  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" rev");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));

  asm(" ldl %n");
  asm(" adc -1");
  asm(" stl %n");

  asm(" fpadd");

  asm(" ldl %n");
  asm(" cj @nowork");
  /*}}}  */
  /*{{{  if ((n&3)==0) goto loop;*/
  asm(" ldl %y");
  asm(" ldl %n");
  asm(" ldc 3");
  asm(" and");
  asm(" ldl %x");
  asm(" rev");
  asm(" cj @loop");
  /*}}}  */
  /*{{{  res+=*x**y; ++x; ++y; --n; if (n==0) goto nowork*/
  asm(" dup");
  FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
  asm(" rev");
  asm(" dup");
  FLT(asm(" fpldnlmulsn")); DBL(asm(" fpldnlmuldb"));

  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" rev");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));

  asm(" ldl %n");
  asm(" adc -1");
  asm(" stl %n");

  asm(" fpadd");

  asm(" ldl %n");
  asm(" cj @nowork");
  /*}}}  */
  /*{{{  if ((n&3)==0) goto loop;*/
  asm(" ldl %y");
  asm(" ldl %n");
  asm(" ldc 3");
  asm(" and");
  asm(" ldl %x");
  asm(" rev");
  asm(" cj @loop");
  /*}}}  */
  /*{{{  res+=*x**y; ++x; ++y; --n; if (n==0) goto nowork*/
  asm(" dup");
  FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
  asm(" rev");
  asm(" dup");
  FLT(asm(" fpldnlmulsn")); DBL(asm(" fpldnlmuldb"));

  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" rev");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));

  asm(" ldl %n");
  asm(" adc -1");
  asm(" stl %n");

  asm(" fpadd");

  asm(" ldl %n");
  asm(" cj @nowork");  
  /*}}}  */
  /*{{{  loop:*/
  asm(" ldc 0");
  asm("@loop");
  /*}}}  */
    /*{{{  res+=*x**y; ++x; ++y;*/
    asm(" diff");
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnlmulsn")); DBL(asm(" fpldnlmuldb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");

    asm(" fpadd");

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    /*}}}  */
    /*{{{  res+=*x**y; ++x; ++y;*/
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnlmulsn")); DBL(asm(" fpldnlmuldb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");

    asm(" fpadd");

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    /*}}}  */
    /*{{{  res+=*x**y; ++x; ++y; n-=4;*/
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnlmulsn")); DBL(asm(" fpldnlmuldb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));

    asm(" ldl %n");
    asm(" adc -4");

    asm(" fpadd");

    asm(" stl %n");
    /*}}}  */
    /*{{{  res+=*x**y; ++x; ++y; n!=0*/
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnlmulsn")); DBL(asm(" fpldnlmuldb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));

    asm(" ldl %n");
    asm(" eqc 0");

    asm(" fpadd");
    /*}}}  */
    /*{{{  if (n!=0) goto loop;*/
    asm(" cj @loop");
    /*}}}  */
  /*{{{  nowork:*/
  asm("@nowork");
  /*}}}  */
#else
  float res=0.0;

  while (n>0) { res+=*x++**y++; --n; }
  return res;
#endif
}
/*}}}  */
