#include <sys/times.h>
#include <stdio.h>

#include "libv.h"

#define MAXEL 100
#define MAXIT 10000

int main(int argc, char *argv[])
{
  double dres[MAXEL],dx[MAXEL],dy[MAXEL];
  float fres[MAXEL],fx[MAXEL],fy[MAXEL];
  struct tms start,end;
  int i;

  for (i=0; i<MAXEL; i++) { fx[i]=41.5; fy[i]=0.5; }
  times(&start);
  for (i=0; i<MAXIT; i++) vecaddflt(res,x,y,MAXEL);
  times(&end);
  printf("REAL32 add: %7d FLOPS\n",HZ*((MAXEL*MAXIT)/(end.tms_utime-start.tms_utime)));
  times(&start);
  for (i=0; i<MAXIT; i++) vecdotflt(x,y,MAXEL);
  times(&end);
  printf("REAL32 dot: %7d FLOPS\n",HZ*((2*MAXEL*MAXIT)/(end.tms_utime-start.tms_utime)));

  for (i=0; i<MAXEL; i++) { dx[i]=41.5; dy[i]=0.5; }
  times(&start);
  for (i=0; i<MAXIT; i++) vecadddbl(res,x,y,MAXEL);
  times(&end);
  printf("REAL64 add: %7d FLOPS\n",HZ*((MAXEL*MAXIT)/(end.tms_utime-start.tms_utime)));
  times(&start);
  for (i=0; i<MAXIT; i++) vecdotdbl(x,y,MAXEL);
  times(&end);
  printf("REAL64 dot: %7d FLOPS\n",HZ*((2*MAXEL*MAXIT)/(end.tms_utime-start.tms_utime)));
  return 0;
}
/*{{{}}}*/
