/*{{{}}}*/
/*{{{  #defines*/
#define FLOAT 1
#define DOUBLE 2

#if TYPE==FLOAT
#define FLT(x) x
#define DBL(x)
#else
#define FLT(x)
#define DBL(x) x
#endif
/*}}}  */

/*{{{  vecaddflt*/
FLT(void vecaddflt(float *res, float *x, float *y, int n))
DBL(void vecadddbl(double *res, double *x, double *y, int n))
{
#ifdef TRANSPUTER
  /*{{{  transputer lcc/assembler version*/
  /*{{{  if (n==0) goto nowork;*/
  asm(" ldl %n");
  asm(" cj @nowork");  
  /*}}}  */
  /*{{{  if ((n&7)==0) goto loop;*/
  asm(" ldl %y");
  asm(" ldl %n");
  asm(" ldc 7");
  asm(" and");
  asm(" ldl %x");
  asm(" rev");
  asm(" cj @loop");
  /*}}}  */
  /*{{{  *res=*x+*y; ++x; ++y; ++res; --n; if (n==0) goto nowork*/
  asm(" dup");
  FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
  asm(" rev");
  asm(" dup");
  FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" rev");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));

  asm(" ldl %n");
  asm(" adc -1");
  asm(" stl %n");

  asm(" ldl %res");
  FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));

  asm(" ldl %res");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" stl %res");

  asm(" ldl %n");
  asm(" cj @nowork");  
  /*}}}  */
  /*{{{  if ((n&7)==0) goto loop;*/
  asm(" ldl %y");
  asm(" ldl %n");
  asm(" ldc 7");
  asm(" and");
  asm(" ldl %x");
  asm(" rev");
  asm(" cj @loop");
  /*}}}  */
  /*{{{  *res=*x+*y; ++x; ++y; ++res; --n; if (n==0) goto nowork*/
  asm(" dup");
  FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
  asm(" rev");
  asm(" dup");
  FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" rev");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));

  asm(" ldl %n");
  asm(" adc -1");
  asm(" stl %n");

  asm(" ldl %res");
  FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));

  asm(" ldl %res");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" stl %res");

  asm(" ldl %n");
  asm(" cj @nowork");  
  /*}}}  */
  /*{{{  if ((n&7)==0) goto loop;*/
  asm(" ldl %y");
  asm(" ldl %n");
  asm(" ldc 7");
  asm(" and");
  asm(" ldl %x");
  asm(" rev");
  asm(" cj @loop");
  /*}}}  */
  /*{{{  *res=*x+*y; ++x; ++y; ++res; --n; if (n==0) goto nowork*/
  asm(" dup");
  FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
  asm(" rev");
  asm(" dup");
  FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" rev");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));

  asm(" ldl %n");
  asm(" adc -1");
  asm(" stl %n");

  asm(" ldl %res");
  FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));

  asm(" ldl %res");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" stl %res");

  asm(" ldl %n");
  asm(" cj @nowork");  
  /*}}}  */
  /*{{{  if ((n&7)==0) goto loop;*/
  asm(" ldl %y");
  asm(" ldl %n");
  asm(" ldc 7");
  asm(" and");
  asm(" ldl %x");
  asm(" rev");
  asm(" cj @loop");
  /*}}}  */
  /*{{{  *res=*x+*y; ++x; ++y; ++res; --n; if (n==0) goto nowork*/
  asm(" dup");
  FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
  asm(" rev");
  asm(" dup");
  FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" rev");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));

  asm(" ldl %n");
  asm(" adc -1");
  asm(" stl %n");

  asm(" ldl %res");
  FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));

  asm(" ldl %res");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" stl %res");

  asm(" ldl %n");
  asm(" cj @nowork");  
  /*}}}  */
  /*{{{  if ((n&7)==0) goto loop;*/
  asm(" ldl %y");
  asm(" ldl %n");
  asm(" ldc 7");
  asm(" and");
  asm(" ldl %x");
  asm(" rev");
  asm(" cj @loop");
  /*}}}  */
  /*{{{  *res=*x+*y; ++x; ++y; ++res; --n; if (n==0) goto nowork*/
  asm(" dup");
  FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
  asm(" rev");
  asm(" dup");
  FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" rev");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));

  asm(" ldl %n");
  asm(" adc -1");
  asm(" stl %n");

  asm(" ldl %res");
  FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));

  asm(" ldl %res");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" stl %res");

  asm(" ldl %n");
  asm(" cj @nowork");  
  /*}}}  */
  /*{{{  if ((n&7)==0) goto loop;*/
  asm(" ldl %y");
  asm(" ldl %n");
  asm(" ldc 7");
  asm(" and");
  asm(" ldl %x");
  asm(" rev");
  asm(" cj @loop");
  /*}}}  */
  /*{{{  *res=*x+*y; ++x; ++y; ++res; --n; if (n==0) goto nowork*/
  asm(" dup");
  FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
  asm(" rev");
  asm(" dup");
  FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" rev");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));

  asm(" ldl %n");
  asm(" adc -1");
  asm(" stl %n");

  asm(" ldl %res");
  FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));

  asm(" ldl %res");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" stl %res");

  asm(" ldl %n");
  asm(" cj @nowork");  
  /*}}}  */
  /*{{{  if ((n&7)==0) goto loop;*/
  asm(" ldl %y");
  asm(" ldl %n");
  asm(" ldc 7");
  asm(" and");
  asm(" ldl %x");
  asm(" rev");
  asm(" cj @loop");
  /*}}}  */
  /*{{{  *res=*x+*y; ++x; ++y; ++res; --n; if (n==0) goto nowork*/
  asm(" dup");
  FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
  asm(" rev");
  asm(" dup");
  FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" rev");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));

  asm(" ldl %n");
  asm(" adc -1");
  asm(" stl %n");

  asm(" ldl %res");
  FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));

  asm(" ldl %res");
  FLT(asm(" adc 4")); DBL(asm(" adc 8"));
  asm(" stl %res");

  asm(" ldl %n");
  asm(" cj @nowork");  
  /*}}}  */
  /*{{{  loop:*/
  asm(" ldc 0");
  asm("@loop");
  /*}}}  */
    /*{{{  *res=*x+*y; ++x; ++y; n-=8;*/
    asm(" diff");
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));

    asm(" ldl %n");
    asm(" adc -8");
    asm(" stl %n");

    asm(" ldl %res");
    FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));
    /*}}}  */
    /*{{{  *(res+1)=*x+*y; ++x; ++y;*/
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));

    asm(" ldl %res");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));
    /*}}}  */
    /*{{{  *(res+2)=*x+*y; ++x; ++y;*/
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));

    asm(" ldl %res");
    FLT(asm(" adc 8")); DBL(asm(" adc 16"));
    FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));
    /*}}}  */
    /*{{{  *(res+3)=*x+*y; ++x; ++y;*/
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));

    asm(" ldl %res");
    FLT(asm(" adc 12")); DBL(asm(" adc 24"));
    FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));
    /*}}}  */
    /*{{{  *(res+4)=*x+*y; ++x; ++y;*/
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));

    asm(" ldl %res");
    FLT(asm(" adc 16")); DBL(asm(" adc 32"));
    FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));
    /*}}}  */
    /*{{{  *(res+5)=*x+*y; ++x; ++y;*/
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));

    asm(" ldl %res");
    FLT(asm(" adc 20")); DBL(asm(" adc 40"));
    FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));
    /*}}}  */
    /*{{{  *(res+6)=*x+*y; ++x; ++y;*/
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));

    asm(" ldl %res");
    FLT(asm(" adc 24")); DBL(asm(" adc 48"));
    FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));
    /*}}}  */
    /*{{{  *(res+7)=*x+*y; ++x; ++y;*/
    asm(" dup");
    FLT(asm(" fpldnlsn")); DBL(asm(" fpldnldb"));
    asm(" rev");
    asm(" dup");
    FLT(asm(" fpldnladdsn")); DBL(asm(" fpldnladddb"));

    FLT(asm(" adc 4")); DBL(asm(" adc 8"));
    asm(" rev");
    FLT(asm(" adc 4")); DBL(asm(" adc 8"));

    asm(" ldl %res");
    FLT(asm(" adc 28")); DBL(asm(" adc 56"));
    FLT(asm(" fpstnlsn")); DBL(asm(" fpstnldb"));
    /*}}}  */
    /*{{{  res+=8*/
    asm(" ldl %res");
    FLT(asm(" adc 32")); DBL(asm(" adc 64"));
    asm(" stl %res");
    /*}}}  */
    /*{{{  if (n!=0) goto loop;*/
    asm(" ldl %n");
    asm(" eqc 0");
    asm(" cj @loop");
    /*}}}  */
  /*{{{  nowork:*/
  asm("@nowork");
  /*}}}  */
  /*}}}  */
#else
  while (n>0) { *res++=*x+++*y++; --n; }
#endif
}
/*}}}  */
