/* $Id: vrdwt.c,v 1.1 1994/06/17 19:08:08 stuart Exp $ */

#define _SYSTEM
#include <lib.h>
#include <minix/com.h>
#include <minix/syslib.h>

/*==========================================================================*
 *				do_vrdwt				    *
 *==========================================================================*/
PUBLIC int do_vrdwt(m_ptr, do_rdwt)
register message *m_ptr;	/* pointer to read or write message */
rdwt_t do_rdwt;			/* pointer to function which does the work */
{
/* Fetch a vector of i/o requests.  Handle requests one at a time.  Return
 * status in the vector.
 */

  register struct iorequest_s *iop;
  static struct iorequest_s iovec[NR_BUFS];
  unsigned nr_requests;
  int request;
  int result;
  message vmessage;
  int proc_nr;
  int device;

  nr_requests = m_ptr->COUNT;
  proc_nr = m_ptr->PROC_NR;
  device = m_ptr->DEVICE;
  if (nr_requests > sizeof iovec / sizeof iovec[0])
	panic("FS gave some driver too big an i/o vector", nr_requests);
  if (mem_copy(m_ptr->PROC_NR, D, (vir_bytes) m_ptr->ADDRESS,
               MYSELF, D, (vir_bytes)iovec,
               (vir_bytes)nr_requests * sizeof iovec[0]))
  {               
     panic("FS gave some driver bad i/o vector", (int) m_ptr->ADDRESS);
  }

  for (request = 0; request < nr_requests; ++request) {
	iop = &iovec[request];
	vmessage.m_type = iop->io_request & ~OPTIONAL_IO;
	vmessage.DEVICE = device;
	vmessage.PROC_NR = proc_nr;
	vmessage.COUNT = iop->io_nbytes;
	vmessage.POSITION = iop->io_position;
	vmessage.ADDRESS = iop->io_buf;
	result = (*do_rdwt)(&vmessage);
	if (result == 0) break;	/* EOF */
	if (result < 0) {
		iop->io_nbytes = result;
		if (iop->io_request & OPTIONAL_IO) break;  /* abort if opt */
	} else
		iop->io_nbytes -= result;
  }

  if (mem_copy(MYSELF, D, (vir_bytes)iovec,
               m_ptr->PROC_NR, D, (vir_bytes) m_ptr->ADDRESS,
               (vir_bytes)nr_requests * sizeof iovec[0]))
  {
    panic("Problem returning IO vector to FS", NO_NUM);
  }               
  return(OK);
}
