/* $Id: putk.c,v 1.3 1995/07/06 17:55:38 stuart Exp $ */

#include <lib.h>
#include <minix/com.h>
#include <minix/syslib.h>

static void writeout(const char *str, size_t sz)
{
  static message putch_msg;	/* used for message to TTY task */
  
  putch_msg.m_type = DEV_WRITE;
  putch_msg.PROC_NR  = -1;      /* Message is coming from a task */
  putch_msg.TTY_LINE = 0;
  putch_msg.ADDRESS  = (char*)str;
  putch_msg.COUNT    = sz;
  _sendrec(TTY, &putch_msg);
}

void putk(const char c)
{
  static char buf[80];
  static size_t buflen=0;

  if (buflen<sizeof(buf)) buf[buflen++]=c;
  else
  {
    writeout(buf,buflen);
    buf[0]=c;
    buflen=1;
  }
  if (c=='\n')
  {
    writeout(buf,buflen);
    buflen=0;
  }
}
