/* $Id: panic.c,v 1.2 1994/10/10 18:17:05 stuart Exp $ */

#include <lib.h>
#include <minix/syslib.h>

#define printf printk

/*===========================================================================*
 *				panic					     *
 *===========================================================================*/
void panic(const char* msg, int num)
{
    printf("%s %d\n", msg, num);
#ifdef _ICC
    __asm{ld msg; sethalterr; seterr;}
#elif defined(__LCC__)
    asm(" ldl %msg\n sethalterr\n seterr");
#else
#error "Unknown C compiler"
#endif
}
