/* $Id: mm_kill.c,v 1.2 1995/04/13 19:45:23 stuart Exp $ */

#include <lib.h>
#include <minix/com.h>
#include <minix/syslib.h>
#include <minix/procnum.h>

PUBLIC int mm_kill(
pid_t pid,                      /* proc or proc group to be signalled */
int sig)                        /* signal number */
{
  message m;
  const int sp_procnum = CREATE_PROCNUM(FAMILY_SERVER, MM_PROC_NR, 100);

  m.PR = pid;
  m.SIGNUM = sig;
  return _taskcall(sp_procnum, SP_KILL_PID, &m);
}
