/* $Id: mem_copy.c,v 1.3 1994/10/10 18:17:05 stuart Exp $ */

#define _SYSTEM
#include <lib.h>
#include <minix/com.h>
#include <minix/syslib.h>

/*===========================================================================*
 *				mem_copy				     *
 *===========================================================================*/
PUBLIC int mem_copy(int src_proc, int src_seg, vir_bytes src_vir,
                    int dst_proc, int dst_seg, vir_bytes dst_vir,
                    vir_bytes bytes)
{
/* Transfer a block of data.  The source and destination can each either be a
 * process (including MM) or absolute memory, indicate by setting 'src_proc'
 * or 'dst_proc' to ABS.
 */

  message copy_mess;

  if (bytes == 0L) return(OK);
  copy_mess.SRC_SPACE = (char) src_seg;
  copy_mess.SRC_PROC_NR = src_proc;
  copy_mess.SRC_BUFFER = src_vir;

  copy_mess.DST_SPACE = (char) dst_seg;
  copy_mess.DST_PROC_NR = dst_proc;
  copy_mess.DST_BUFFER = dst_vir;

  copy_mess.COPY_BYTES = bytes;
  return _taskcall(_local_systask, SYS_COPY, &copy_mess);
}
