;{{{}}}
;{{{  Comments
; Although this is described as a semaphore, it actually implements a
; simple spin lock. It is designed for mutual exclusion between HPPs and
; a single low priority task.
;
; Tasks can call:
;    sem_claim()   to ensure any HPPs are blocked.
;                  (This can be replaced by sem.sem = MININT.)
;    sem_release() to allow any HPPs to run.
;
; HPPs can call:
;    sem_claim()   to ensure they are not locked out by the task or
;                  another HPP.
;    sem_release() to allow any blocked HPPs to run.
;}}}
;{{{  Constants
     equ @SEM_SEM,0
     equ @SEM_HEAD,1
     equ @SEM_TAIL,2
;}}}

;{{{  sem_init
;    Initialise the semaphore.
;    Called as "void sem_init(sem_s *sem)"
;    1  sem
;    0  return Iptr
_sem_init
        ldc     0
        ldl     1
        stnl    @SEM_SEM
        mint
        ldl     1
        stnl    @SEM_HEAD
        ret
;}}}
;{{{  sem_claim
;    Claim the semaphore. If semaphore is already claimed by another, wait.
;    Called as "void sem_claim(sem_s *sem)"
;    1  sem
;    0  return Iptr
_sem_claim
     ldl 1
;    Should be a "ldnlp SEM_SEM" here, but that is a no-op as SEM_SEM=0.
     resetch
     cj @sc_in
;    Semaphore was already claimed, wait.
     ldtimer
     ldc 1000
     sum
     tin
     j _sem_claim

@sc_in
;    We have now been granted the semaphore.
     ret
;}}}
;{{{  sem_release
;    Release the semaphore.
;    Called as "void sem_release(sem_s *sem)"
;    1  sem
;    0  return Iptr
_sem_release
;    Release the semaphore and return.
     ldc     0
     ldl     1
     stnl @SEM_SEM
     ret
;}}}
