;{{{  Notes
; Run the indicated process at high prioritpy.
; Note: stack param is address of top of stack on entry to the function.
; It is the users responsability to ensure at at least the next four
; words are free.
;
; Called as: void run_process(void* stack, void* fn_ptr, int num_params, ...)
;
;  5  ...
;  4  params
;  3  num_params
;  2  fn_ptr
;  1  stack
;  0  return Iptr
;}}}
;{{{  equs
     equ @params,4
     equ @num_params,3
     equ @fn_ptr,2
     equ @stack,1
     equ @return_IPtr,0
;}}}

_run_process
;    Copy parameters
     ldlp    @params
     ldl     @stack
     ldnlp   @stack
     ldl     @num_params
     bcnt
;    A = len, B = dest, C = src
     move

;    Set up return Iptr
     ldpi @return
     ldl     @stack
     stnl    @return_IPtr

;    Set up initial Iptr
     ldl     @fn_ptr
     ldl     @stack
     stnl    -1

     ldl     @stack
     runp
     ret

;    This is where the hpp will return to, if it returns.
;    This will overwrite what has become the -1 workspace slot,
;    but as this is the 2nd parameter for the call, we dont care.
@return
     stopp
