/* $Id: is_write.c,v 1.3 1994/10/10 18:17:05 stuart Exp $ */

#include <lib.h>
#include <transputer/iserver.h>

int iserver_write(const int fd, const void* buffer, const int count)
{
  int remaining;    /* Remaining bytes to transfer */
  int max_len;      /* Maximum length of write */
  int request_len;  /* Length to write */
  char result;      /* Result of write */
  int result_len;   /* Length of data write */
  int total_len;    /* Total length write */
  int error;        /* Host error code (unused) */
  static char request[1] = { SP_WRITE };
  iovec_t iovec[6] = {
    { (vir_bytes)NULL,    1},   /* Request */
    { (vir_bytes)NULL,    4},   /* fd */
    { (vir_bytes)NULL,    2},   /* length */
    { (vir_bytes)NULL,    0},   /* data */
    { (vir_bytes)NULL,    1},   /* result */
    { (vir_bytes)NULL,    2}    /* length */
  };

  iovec[0].iov_addr = (vir_bytes)request;
  iovec[1].iov_addr = (vir_bytes)&fd;
  iovec[2].iov_addr = (vir_bytes)&request_len;
  iovec[4].iov_addr = (vir_bytes)&result;
  iovec[5].iov_addr = (vir_bytes)&result_len;

  remaining = count;
  total_len = 0;
  result_len = 0;   /* Reset MSBs */

  if (iserver_max_packet_size == -1) {
        /* Use has not called iserver_init. Use something safe. */
        max_len = 512 - 9; /* 9=pkt length(2 bytes) + tag(1) + fd(4) + len(2) */
  } else {
        max_len = iserver_max_packet_size - 9;
  }

  while (remaining > 0)
  {
        request_len = (remaining > max_len) ? max_len : remaining;
        iovec[3].iov_addr = (vir_bytes)buffer;
        iovec[3].iov_size = (vir_bytes)request_len;

        iserver_message(iovec, 4, 2);

        /* This should never happen acording to the specification, but
         * IServer 1.5 returns a failure if you pass it a duff parameter.
         */
        if (result != ER_SUCCESS) {
            return -result;
        }

        remaining -= result_len;
        total_len += result_len;
        buffer     = ((char*)buffer) + result_len;

        if (result_len != request_len) {
                if (iserver_error(fd, &error, NULL, 0) != ER_SUCCESS)
                        return total_len;   /* EOF */
                else
                        return -ER_ERROR;   /* Error */
        }
  }

  return total_len;
}
