/* $Id: is_seek.c,v 1.2 1994/10/10 18:17:05 stuart Exp $ */

#include <lib.h>
#include <transputer/iserver.h>

int iserver_seek(const int fd, long position)
{
  char result;      /* Result of write */
  static char request[1] = { SP_SEEK };
  static int origin = 1;    /* Set ie offset from start of file */
  iovec_t iovec[5] = {
    { (vir_bytes)NULL,    1},   /* Request */
    { (vir_bytes)NULL,    4},   /* fd */
    { (vir_bytes)NULL,    4},   /* offset */
    { (vir_bytes)NULL,    4},   /* origin */
    { (vir_bytes)NULL,    1},   /* result */
  };

  iovec[0].iov_addr = (vir_bytes)request;
  iovec[1].iov_addr = (vir_bytes)&fd;
  iovec[2].iov_addr = (vir_bytes)&position;
  iovec[3].iov_addr = (vir_bytes)&origin;
  iovec[4].iov_addr = (vir_bytes)&result;

  iserver_message(iovec, 4, 1);

  return result;
}
