/* $Id: is_read.c,v 1.3 1994/10/10 18:17:05 stuart Exp $ */

#include <lib.h>
#include <transputer/iserver.h>

int iserver_read(const int fd, void* buffer, const int count)
{
  int remaining;    /* Remaining bytes to transfer */
  int max_len;      /* Maximum length of read */
  int request_len;  /* Length to read */
  char result;      /* Result of read */
  int result_len;   /* Length of data read */
  int total_len;    /* Total length read */
  int error;        /* Host error code (unused) */
  static char request[1] = { SP_READ };
  iovec_t iovec[6] = {
    { (vir_bytes)NULL,    1},   /* Request */
    { (vir_bytes)NULL,    4},   /* fd */
    { (vir_bytes)NULL,    2},   /* length */
    { (vir_bytes)NULL,    1},   /* Result */
    { (vir_bytes)NULL,    2},   /* Length */
    { (vir_bytes)NULL,    0}    /* data */
  };

  iovec[0].iov_addr = (vir_bytes)request;
  iovec[1].iov_addr = (vir_bytes)&fd;
  iovec[2].iov_addr = (vir_bytes)&request_len;
  iovec[3].iov_addr = (vir_bytes)&result;
  iovec[4].iov_addr = (vir_bytes)&result_len;

  remaining = count;
  total_len = 0;
  result_len = 0;   /* Reset MSBs */

  if (iserver_max_packet_size == -1) {
        /* Use has not called iserver_init. Use something safe. */
        max_len = 512 - 5; /* 5=pkt length(2 bytes) + result(1) + length(2) */
  } else {
        max_len = iserver_max_packet_size - 5;
  }

  while (remaining > 0)
  {
        request_len = (remaining > max_len) ? max_len : remaining;
        iovec[5].iov_addr = (vir_bytes)buffer;
        iovec[5].iov_size = (vir_bytes)request_len;

        iserver_message(iovec, 3, 3);

        /* This should never happen acording to the specification, but
         * IServer 1.5 returns a failure if you pass it a duff parameter.
         */
        if (result != ER_SUCCESS) {
            return -result;
        }

        remaining -= result_len;
        total_len += result_len;
        buffer     = ((char*)buffer) + result_len;

        if (result_len != request_len) {
                if (iserver_error(fd, &error, NULL, 0) != ER_SUCCESS)
                        return total_len;   /* EOF */
                else
                        return -ER_ERROR;   /* Error */
        }
  }

  return total_len;
}
