/* $Id: is_open.c,v 1.3 1994/10/10 18:17:05 stuart Exp $ */

#include <lib.h>
#include <string.h>
#include <transputer/iserver.h>

int iserver_open(const char* filename, int org, int mode, int* fd)
{
  static unsigned char request[1] = { SP_OPEN };
  char result;
  int len;
  iovec_t iovec[7] = {
    { (vir_bytes)NULL,    1},
    { (vir_bytes)NULL,    2},
    { (vir_bytes)NULL,    0},
    { (vir_bytes)NULL,    1},
    { (vir_bytes)NULL,    1},
    { (vir_bytes)NULL,    1},
    { (vir_bytes)NULL,    4}
  };

  len = strlen(filename);
  iovec[0].iov_addr = (vir_bytes)request;
  iovec[1].iov_addr = (vir_bytes)&len;
  iovec[2].iov_addr = (vir_bytes)filename;
  iovec[2].iov_size = (vir_bytes)len;
  iovec[3].iov_addr = (vir_bytes)&org;
  iovec[4].iov_addr = (vir_bytes)&mode;
  iovec[5].iov_addr = (vir_bytes)&result;
  iovec[6].iov_addr = (vir_bytes)fd;
  
  iserver_message(iovec, 5, 2);

  return (int)result;
}
