/* $Id: is_message.c,v 1.2 1994/08/02 16:28:08 stuart Exp $ */

#include <lib.h>
#include <minix/com.h>
#include <transputer/channel.h>
#include <transputer/sem.h>
#include <transputer/support.h>
#include <transputer/iserver.h>

#define receive _receive
#define interrupt _interrupt
#include <minix/syslib.h>

/* Information which is needed by iserver_message. */
PRIVATE struct link_details* link_details = NULL;
PRIVATE int proc_nr;

FORWARD void do_message(iovec_t *iov, unsigned int nr_writes,
                        unsigned int nr_reads);

/*===========================================================================*
 *                             iserver_message                               *
 *===========================================================================*/
PUBLIC void iserver_message(
    iovec_t      *iov,          /* Vector of requests */
    unsigned int  nr_writes,    /* Number of writes in vector */
    unsigned int  nr_reads)     /* Number of reads in vector */
{
  /*
   * A task has issused a scatterd IO request to the host link.
   * Having got information about the host link if required,
   * we output the writes and then read back as many reads as possible.
   * Any surplus is read and discarded.
   */

  int stack[32];
  message msg;

  /* Get details about the link. */
  /* Note that this also gives us the task number. This is a nasty hack,
   * and will probablly need to change. */
  if (link_details == NULL) {
        _taskcall(_local_systask, SYS_BLINK, &msg);
        link_details = (struct link_details*)msg.MEM_PTR;
        proc_nr = msg.m_source;
  }

  run_process(&stack[32-5], do_message, 3, iov, nr_writes, nr_reads);
  receive(HARDWARE, &msg);
}  

/*===========================================================================*
 *                             do_message                                    *
 *===========================================================================*/
PRIVATE void do_message(iovec_t *iov, unsigned int nr_writes,
                        unsigned int nr_reads)
{
  int length;           /* Total length of input or output message. */
  int partlen;          /* Length of this part of the message. */
  int padding;          /* Length of padding. */
  int i;

  sem_claim(&link_details->sem);

  /* Find the length of the outgoing message. */
  length = 0;
  for (i = 0; i < nr_writes; i++) {
        length += (int)iov[i].iov_size;
  }

  /* Pad to minimum IServer requirements. */
  if (length < 6) {
        padding = 6 - length;
  } else {
        padding = length & 1;
  }
    
  /* Send the request. */
  ChanOutInt16(link_details->linkOut, length + padding);
  for ( ; nr_writes > 0; nr_writes--) {
        ChanOut(link_details->linkOut, (void*)iov->iov_addr,
                (int)iov->iov_size);
        iov++;
  }

  /* Send any padding required. */
  if (padding > 0)
        ChanOut(link_details->linkOut, (void*)MININT, padding);

  /* Now get the result. */
  length = ChanInInt16(link_details->linkIn);
  for ( ; (nr_reads > 0) && (length >0); nr_reads--) {
        partlen = (int)iov->iov_size;
        if (partlen > length)
                partlen = length;
                
        ChanIn(link_details->linkIn, (void*)iov->iov_addr, partlen);
        length -= partlen;
        iov++;
  }

  /* Read in any padding. */
  for ( ; length > 0; length--)
        (void)ChanInByte(link_details->linkIn);

  sem_release(&link_details->sem);

  interrupt(proc_nr);
}

