/* $Id: is_init.c,v 1.2 1994/10/10 18:17:05 stuart Exp $ */

#include <lib.h>
#include <transputer/iserver.h>

void iserver_init(void)
{
  /* Determine which IServer we are using, and thus max packet size */

  static char version_request[1] = {
    SP_ID
  };
  static char getinfo_request[4] = {
    SP_GETINFO,                         /* Request */
    INFO_PKTSIZE,                       /* Tag: Max packet size */
    sizeof(iserver_max_packet_size), 0  /* size of result */
  };
  static char putblock_request[7] = {
    SP_PUTBLOCK,                        /* Request */
    1, 0, 0, 0,                         /* Stream: stdout */
    0, 0                                /* Length: 0 */
  };
  char result;
  iovec_t iovec[3] = {                  /* Initial values for SP_ID */
    { (vir_bytes)NULL,            1},   /* Request */
    { (vir_bytes)NULL,            1},   /* result */
    { (vir_bytes)NULL,            1},   /* version */
  };

  /* Initially get the IServer version number. */
  iovec[0].iov_addr = (vir_bytes)version_request;
  iovec[1].iov_addr = (vir_bytes)&result;
  iovec[2].iov_addr = (vir_bytes)&iserver_version;

  iserver_message(iovec, 1, 2);
 
  if (iserver_version >= 15) {
    /* We have a 1.5 IServer, so it will support the SP_GETOPT message. This
     * can give us the max packet size directly.
     */
    iovec[0].iov_addr = (vir_bytes)getinfo_request;
    iovec[0].iov_size = (vir_bytes)sizeof(getinfo_request);
    iovec[2].iov_addr = (vir_bytes)&iserver_max_packet_size;
    iovec[2].iov_size = (vir_bytes)sizeof(iserver_max_packet_size);

    iserver_message(iovec, 1, 2);

    iserver_block_ops = 1;  /* We also have block operations available. */

    return;
  }

  /* We are using a pre-1.5 IServer, so we have to use the presence or
   * absence of the SP_GETBLOCK command to differentiate between the
   * 1.41 and 1.42 IServers. 
   */
  iovec[0].iov_addr = (vir_bytes)putblock_request;
  iovec[0].iov_size = (vir_bytes)sizeof(putblock_request);

  iserver_message(iovec, 1, 1);

  iserver_block_ops = (result == ER_SUCCESS);

  if (iserver_block_ops) {
    iserver_max_packet_size = 1024;     /* 1.42 Iserver. */
  } else {
    iserver_max_packet_size = 512;      /* 1.41 Iserver. */
  }
}
